/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.UnionExchange;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;

public class UnionExchangePrel
extends ExchangePrel {
    public UnionExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input) {
        super(cluster, traitSet, input);
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new UnionExchangePrel(this.getCluster(), traitSet, UnionExchangePrel.sole(inputs));
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        UnionExchange g = new UnionExchange(childPOP);
        return creator.addMetadata(this, g);
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

