/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.UnionAllPrel;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.trace.EigenbaseTrace;

public class UnionAllPrule
extends Prule {
    public static final RelOptRule INSTANCE = new UnionAllPrule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private UnionAllPrule() {
        super(RelOptHelper.any(DrillUnionRel.class), "Prel.UnionAllPrule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        return !union.isDistinct();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillUnionRel union = (DrillUnionRel)call.rel(0);
        List<RelNode> inputs = union.getInputs();
        ArrayList<RelNode> convertedInputList = Lists.newArrayList();
        RelTraitSet traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL);
        try {
            for (int i = 0; i < inputs.size(); ++i) {
                RelNode convertedInput = UnionAllPrule.convert(inputs.get(i), PrelUtil.fixTraits(call, traits));
                convertedInputList.add(convertedInput);
            }
            traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(DrillDistributionTrait.SINGLETON);
            UnionAllPrel unionAll = new UnionAllPrel(union.getCluster(), traits, convertedInputList);
            call.transformTo(unionAll);
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }
}

