/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.relopt.volcano.RelSubset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SubsetTransformer<T extends RelNode, E extends Exception> {
    static final Logger logger = LoggerFactory.getLogger(SubsetTransformer.class);
    private final RelOptRuleCall call;

    public abstract RelNode convertChild(T var1, RelNode var2) throws E;

    public SubsetTransformer(RelOptRuleCall call) {
        this.call = call;
    }

    public RelTraitSet newTraitSet(RelTrait ... traits) {
        RelTraitSet set = this.call.getPlanner().emptyTraitSet();
        for (RelTrait t : traits) {
            set = set.plus(t);
        }
        return set;
    }

    boolean go(T n, RelNode candidateSet) throws E {
        if (!(candidateSet instanceof RelSubset)) {
            return false;
        }
        boolean transform = false;
        for (RelNode rel : ((RelSubset)candidateSet).getRelList()) {
            RelNode out;
            if (this.isDefaultDist(rel) || (out = this.convertChild(n, rel)) == null) continue;
            this.call.transformTo(out);
            transform = true;
        }
        return transform;
    }

    private boolean isDefaultDist(RelNode n) {
        return n.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE).equals(DrillDistributionTrait.DEFAULT);
    }
}

