/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillSortRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SingleMergeExchangePrel;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;

public class SortPrule
extends Prule {
    public static final RelOptRule INSTANCE = new SortPrule();

    private SortPrule() {
        super(RelOptHelper.any(DrillSortRel.class, DrillRel.DRILL_LOGICAL), "Prel.SortPrule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillSortRel sort = (DrillSortRel)call.rel(0);
        RelNode input = sort.getChild();
        DrillDistributionTrait hashDistribution = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(sort)));
        RelTraitSet traits = sort.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(hashDistribution);
        RelNode convertedInput = SortPrule.convert(input, traits);
        if (SortPrule.isSingleMode(call)) {
            call.transformTo(convertedInput);
        } else {
            SingleMergeExchangePrel exch = new SingleMergeExchangePrel(sort.getCluster(), sort.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(DrillDistributionTrait.SINGLETON), convertedInput, sort.getCollation());
            call.transformTo(exch);
        }
    }

    private List<DrillDistributionTrait.DistributionField> getDistributionField(DrillSortRel rel) {
        ArrayList<DrillDistributionTrait.DistributionField> distFields = Lists.newArrayList();
        for (RelFieldCollation relField : rel.getCollation().getFieldCollations()) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(relField.getFieldIndex());
            distFields.add(field);
        }
        return distFields;
    }
}

