/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;

public class ScanPrule
extends Prule {
    public static final RelOptRule INSTANCE = new ScanPrule();

    public ScanPrule() {
        super(RelOptHelper.any(DrillScanRel.class), "Prel.ScanPrule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillScanRel scan = (DrillScanRel)call.rel(0);
        GroupScan groupScan = scan.getGroupScan();
        DrillDistributionTrait partition = groupScan.getMaxParallelizationWidth() > 1 ? DrillDistributionTrait.RANDOM_DISTRIBUTED : DrillDistributionTrait.SINGLETON;
        RelTraitSet traits = scan.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(partition);
        ScanPrel newScan = ScanPrel.create(scan, traits, groupScan, scan.getRowType());
        call.transformTo(newScan);
    }
}

