/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.hydromatic.linq4j.Ord;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelCollationImpl;
import org.eigenbase.rel.RelCollationTraitDef;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.SqlKind;

public class ProjectPrule
extends Prule {
    public static final RelOptRule INSTANCE = new ProjectPrule();

    private ProjectPrule() {
        super(RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "ProjectPrule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillProjectRel project = (DrillProjectRel)call.rel(0);
        RelNode input = project.getChild();
        RelTraitSet traits = input.getTraitSet().plus(Prel.DRILL_PHYSICAL);
        RelNode convertedInput = ProjectPrule.convert(input, traits);
        Map<Integer, Integer> inToOut = this.getProjectMap(project);
        boolean traitPull = new ProjectTraitPull(call, inToOut).go(project, convertedInput);
        if (!traitPull) {
            call.transformTo(new ProjectPrel(project.getCluster(), convertedInput.getTraitSet(), convertedInput, project.getProjects(), project.getRowType()));
        }
    }

    private DrillDistributionTrait convertDist(DrillDistributionTrait srcDist, Map<Integer, Integer> inToOut) {
        ArrayList<DrillDistributionTrait.DistributionField> newFields = Lists.newArrayList();
        for (DrillDistributionTrait.DistributionField field : srcDist.getFields()) {
            if (!inToOut.containsKey(field.getFieldId())) continue;
            newFields.add(new DrillDistributionTrait.DistributionField(inToOut.get(field.getFieldId())));
        }
        if (newFields.isEmpty()) {
            if (srcDist.getType() != DrillDistributionTrait.DistributionType.SINGLETON) {
                return DrillDistributionTrait.RANDOM_DISTRIBUTED;
            }
            return DrillDistributionTrait.SINGLETON;
        }
        return new DrillDistributionTrait(srcDist.getType(), ImmutableList.copyOf(newFields));
    }

    private RelCollation convertRelCollation(RelCollation src, Map<Integer, Integer> inToOut) {
        ArrayList<RelFieldCollation> newFields = Lists.newArrayList();
        for (RelFieldCollation field : src.getFieldCollations()) {
            if (!inToOut.containsKey(field.getFieldIndex())) continue;
            newFields.add(new RelFieldCollation(inToOut.get(field.getFieldIndex()), field.getDirection()));
        }
        if (newFields.isEmpty()) {
            return RelCollationImpl.EMPTY;
        }
        return RelCollationImpl.of(newFields);
    }

    private Map<Integer, Integer> getProjectMap(DrillProjectRel project) {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        for (Ord<RexNode> node : Ord.zip(project.getProjects())) {
            RexNode operand;
            if (node.e instanceof RexInputRef) {
                m.put(((RexInputRef)node.e).getIndex(), node.i);
                continue;
            }
            if (!((RexNode)node.e).isA(SqlKind.CAST) || !((operand = ((RexCall)node.e).getOperands().get(0)) instanceof RexInputRef)) continue;
            m.put(((RexInputRef)operand).getIndex(), node.i);
        }
        return m;
    }

    private class ProjectTraitPull
    extends SubsetTransformer<DrillProjectRel, RuntimeException> {
        final Map<Integer, Integer> inToOut;

        public ProjectTraitPull(RelOptRuleCall call, Map<Integer, Integer> inToOut) {
            super(call);
            this.inToOut = inToOut;
        }

        @Override
        public RelNode convertChild(DrillProjectRel project, RelNode rel) throws RuntimeException {
            DrillDistributionTrait childDist = rel.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE);
            RelCollation childCollation = rel.getTraitSet().getTrait(RelCollationTraitDef.INSTANCE);
            DrillDistributionTrait newDist = ProjectPrule.this.convertDist(childDist, this.inToOut);
            RelCollation newCollation = ProjectPrule.this.convertRelCollation(childCollation, this.inToOut);
            RelTraitSet newProjectTraits = rel.getTraitSet().plus(newDist).plus(newCollation);
            return new ProjectPrel(project.getCluster(), newProjectTraits, rel, project.getProjects(), project.getRowType());
        }
    }
}

