/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.Project;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public class ProjectAllowDupPrel
extends ProjectPrel {
    public ProjectAllowDupPrel(RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traits, child, exps, rowType);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        Project p = new Project(this.getProjectExpressions(new DrillParseContext()), childPOP);
        return creator.addMetadata(this, p);
    }

    @Override
    protected List<NamedExpression> getProjectExpressions(DrillParseContext context) {
        ArrayList<NamedExpression> expressions = Lists.newArrayList();
        for (Pair pair : Pair.zip(this.exps, this.getRowType().getFieldNames())) {
            LogicalExpression expr = DrillOptiq.toDrill(context, this.getChild(), (RexNode)pair.left);
            expressions.add(new NamedExpression(expr, FieldReference.getWithQuotedRef((CharSequence)pair.right)));
        }
        return expressions;
    }
}

