/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.carrotsearch.hppc.IntIntOpenHashMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.PathSegment;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelFieldCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexLocalRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexShuttle;
import org.eigenbase.rex.RexVisitorImpl;

public class PrelUtil {
    public static List<Order.Ordering> getOrdering(RelCollation collation, RelDataType rowType) {
        ArrayList<Order.Ordering> orderExpr = Lists.newArrayList();
        List<String> childFields = rowType.getFieldNames();
        for (RelFieldCollation fc : collation.getFieldCollations()) {
            FieldReference fr = new FieldReference((CharSequence)childFields.get(fc.getFieldIndex()), ExpressionPosition.UNKNOWN);
            orderExpr.add(new Order.Ordering(fc.getDirection(), fr, fc.nullDirection));
        }
        return orderExpr;
    }

    public static LogicalExpression getHashExpression(List<DrillDistributionTrait.DistributionField> fields, RelDataType rowType) {
        assert (fields.size() > 0);
        List<String> childFields = rowType.getFieldNames();
        FieldReference fr = new FieldReference((CharSequence)childFields.get(fields.get(0).getFieldId()), ExpressionPosition.UNKNOWN);
        FunctionCall func = new FunctionCall("hash", ImmutableList.of(fr), ExpressionPosition.UNKNOWN);
        for (int i = 1; i < fields.size(); ++i) {
            fr = new FieldReference((CharSequence)childFields.get(fields.get(i).getFieldId()), ExpressionPosition.UNKNOWN);
            FunctionCall func2 = new FunctionCall("hash", ImmutableList.of(fr), ExpressionPosition.UNKNOWN);
            func = new FunctionCall("xor", ImmutableList.of(func, func2), ExpressionPosition.UNKNOWN);
        }
        return func;
    }

    public static Iterator<Prel> iter(RelNode ... nodes) {
        return Arrays.asList(nodes).iterator();
    }

    public static Iterator<Prel> iter(List<RelNode> nodes) {
        return nodes.iterator();
    }

    public static PlannerSettings getSettings(RelOptCluster cluster) {
        return cluster.getPlanner().getContext().unwrap(PlannerSettings.class);
    }

    public static PlannerSettings getPlannerSettings(RelOptPlanner planner) {
        return planner.getContext().unwrap(PlannerSettings.class);
    }

    public static ProjectPushInfo getColumns(RelDataType rowType, List<RexNode> projects) {
        List<String> fieldNames = rowType.getFieldNames();
        if (fieldNames.isEmpty()) {
            return null;
        }
        RefFieldsVisitor v = new RefFieldsVisitor(rowType);
        for (RexNode exp : projects) {
            PathSegment segment = exp.accept(v);
            v.addColumn(segment);
        }
        return v.getInfo();
    }

    public static RelTraitSet fixTraits(RelOptRuleCall call, RelTraitSet set) {
        return PrelUtil.fixTraits(call.getPlanner(), set);
    }

    public static RelTraitSet fixTraits(RelOptPlanner cluster, RelTraitSet set) {
        if (PrelUtil.getPlannerSettings(cluster).isSingleMode()) {
            return set.replace(DrillDistributionTrait.ANY);
        }
        return set;
    }

    public static class InputRewriter
    extends RexShuttle {
        final IntIntOpenHashMap map;

        public InputRewriter(IntIntOpenHashMap map) {
            this.map = map;
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return new RexInputRef(this.map.get(inputRef.getIndex()), inputRef.getType());
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef localRef) {
            return new RexInputRef(this.map.get(localRef.getIndex()), localRef.getType());
        }
    }

    private static class RefFieldsVisitor
    extends RexVisitorImpl<PathSegment> {
        final Set<SchemaPath> columns = Sets.newLinkedHashSet();
        private final List<String> fieldNames;
        private final List<RelDataTypeField> fields;
        private final Set<DesiredField> desiredFields = Sets.newHashSet();

        public RefFieldsVisitor(RelDataType rowType) {
            super(true);
            this.fieldNames = rowType.getFieldNames();
            this.fields = rowType.getFieldList();
        }

        public void addColumn(PathSegment segment) {
            if (segment != null && segment instanceof PathSegment.NameSegment) {
                this.columns.add(new SchemaPath((PathSegment.NameSegment)segment));
            }
        }

        public ProjectPushInfo getInfo() {
            return new ProjectPushInfo(ImmutableList.copyOf(this.columns), ImmutableList.copyOf(this.desiredFields));
        }

        @Override
        public PathSegment visitInputRef(RexInputRef inputRef) {
            int index = inputRef.getIndex();
            String name = this.fieldNames.get(index);
            RelDataTypeField field = this.fields.get(index);
            DesiredField f = new DesiredField(index, name, field);
            this.desiredFields.add(f);
            return new PathSegment.NameSegment(name);
        }

        @Override
        public PathSegment visitCall(RexCall call) {
            if ("ITEM".equals(call.getOperator().getName())) {
                PathSegment mapOrArray = ((RexNode)call.operands.get(0)).accept(this);
                if (mapOrArray != null) {
                    if (call.operands.get(1) instanceof RexLiteral) {
                        return mapOrArray.cloneWithNewChild(this.convertLiteral((RexLiteral)call.operands.get(1)));
                    }
                    return mapOrArray;
                }
            } else {
                for (RexNode operand : call.operands) {
                    this.addColumn(operand.accept(this));
                }
            }
            return null;
        }

        private PathSegment convertLiteral(RexLiteral literal) {
            switch (literal.getType().getSqlTypeName()) {
                case CHAR: {
                    return new PathSegment.NameSegment(RexLiteral.stringValue(literal));
                }
                case INTEGER: {
                    return new PathSegment.ArraySegment(RexLiteral.intValue(literal));
                }
            }
            return null;
        }
    }

    public static class ProjectPushInfo {
        public final List<SchemaPath> columns;
        public final List<DesiredField> desiredFields;
        public final InputRewriter rewriter;
        private final List<String> fieldNames;
        private final List<RelDataType> types;

        public ProjectPushInfo(List<SchemaPath> columns, ImmutableList<DesiredField> desiredFields) {
            this.columns = columns;
            this.desiredFields = desiredFields;
            this.fieldNames = Lists.newArrayListWithCapacity(desiredFields.size());
            this.types = Lists.newArrayListWithCapacity(desiredFields.size());
            IntIntOpenHashMap oldToNewIds = new IntIntOpenHashMap();
            int i = 0;
            for (DesiredField f : desiredFields) {
                this.fieldNames.add(f.name);
                this.types.add(f.field.getType());
                oldToNewIds.put(f.origIndex, i);
                ++i;
            }
            this.rewriter = new InputRewriter(oldToNewIds);
        }

        public InputRewriter getInputRewriter() {
            return this.rewriter;
        }

        public boolean isStarQuery() {
            for (SchemaPath column : this.columns) {
                if (!column.getRootSegment().getPath().startsWith("*")) continue;
                return true;
            }
            return false;
        }

        public RelDataType createNewRowType(RelDataTypeFactory factory) {
            return factory.createStructType(this.types, this.fieldNames);
        }
    }

    public static class DesiredField {
        public final int origIndex;
        public final String name;
        public final RelDataTypeField field;

        public DesiredField(int origIndex, String name, RelDataTypeField field) {
            this.origIndex = origIndex;
            this.name = name;
            this.field = field;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.field == null ? 0 : this.field.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + this.origIndex;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DesiredField other = (DesiredField)obj;
            if (this.field == null ? other.field != null : !this.field.equals(other.field)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.origIndex == other.origIndex;
        }
    }
}

