/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import org.apache.drill.exec.server.options.OptionManager;
import org.apache.drill.exec.server.options.OptionValidator;
import org.apache.drill.exec.server.options.TypeValidators;
import org.eigenbase.relopt.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlannerSettings
implements Context {
    static final Logger logger = LoggerFactory.getLogger(PlannerSettings.class);
    private int numEndPoints = 0;
    private boolean useDefaultCosting = false;
    public static final OptionValidator EXCHANGE = new TypeValidators.BooleanValidator("planner.disable_exchanges", false);
    public static final OptionValidator HASHAGG = new TypeValidators.BooleanValidator("planner.enable_hashagg", true);
    public static final OptionValidator STREAMAGG = new TypeValidators.BooleanValidator("planner.enable_streamagg", true);
    public static final OptionValidator HASHJOIN = new TypeValidators.BooleanValidator("planner.enable_hashjoin", true);
    public static final OptionValidator MERGEJOIN = new TypeValidators.BooleanValidator("planner.enable_mergejoin", true);
    public static final OptionValidator MULTIPHASE = new TypeValidators.BooleanValidator("planner.enable_multiphase_agg", true);
    public static final OptionValidator BROADCAST = new TypeValidators.BooleanValidator("planner.enable_broadcast_join", true);
    public static final OptionValidator BROADCAST_THRESHOLD = new TypeValidators.PositiveLongValidator("planner.broadcast_threshold", Integer.MAX_VALUE, 1000000L);
    public static final OptionValidator JOIN_ROW_COUNT_ESTIMATE_FACTOR = new TypeValidators.RangeDoubleValidator("planner.join.row_count_estimate_factor", 0.0, 100.0, 1.0);
    public static final OptionValidator PRODUCER_CONSUMER = new TypeValidators.BooleanValidator("planner.add_producer_consumer", false);
    public static final OptionValidator PRODUCER_CONSUMER_QUEUE_SIZE = new TypeValidators.LongValidator("planner.producer_consumer_queue_size", 10L);
    public static final OptionValidator HASH_SINGLE_KEY = new TypeValidators.BooleanValidator("planner.enable_hash_single_key", true);
    public OptionManager options = null;

    public PlannerSettings(OptionManager options) {
        this.options = options;
    }

    public boolean isSingleMode() {
        return this.options.getOption((String)PlannerSettings.EXCHANGE.getOptionName()).bool_val;
    }

    public int numEndPoints() {
        return this.numEndPoints;
    }

    public double getRowCountEstimateFactor() {
        return this.options.getOption((String)PlannerSettings.JOIN_ROW_COUNT_ESTIMATE_FACTOR.getOptionName()).float_val;
    }

    public boolean useDefaultCosting() {
        return this.useDefaultCosting;
    }

    public void setNumEndPoints(int numEndPoints) {
        this.numEndPoints = numEndPoints;
    }

    public boolean isHashAggEnabled() {
        return this.options.getOption((String)PlannerSettings.HASHAGG.getOptionName()).bool_val;
    }

    public boolean isStreamAggEnabled() {
        return this.options.getOption((String)PlannerSettings.STREAMAGG.getOptionName()).bool_val;
    }

    public boolean isHashJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.HASHJOIN.getOptionName()).bool_val;
    }

    public boolean isMergeJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.MERGEJOIN.getOptionName()).bool_val;
    }

    public boolean isMultiPhaseAggEnabled() {
        return this.options.getOption((String)PlannerSettings.MULTIPHASE.getOptionName()).bool_val;
    }

    public boolean isBroadcastJoinEnabled() {
        return this.options.getOption((String)PlannerSettings.BROADCAST.getOptionName()).bool_val;
    }

    public boolean isHashSingleKey() {
        return this.options.getOption((String)PlannerSettings.HASH_SINGLE_KEY.getOptionName()).bool_val;
    }

    public long getBroadcastThreshold() {
        return this.options.getOption((String)PlannerSettings.BROADCAST_THRESHOLD.getOptionName()).num_val;
    }

    public long getSliceTarget() {
        return this.options.getOption((String)"planner.slice_target").num_val;
    }

    public boolean isMemoryEstimationEnabled() {
        return this.options.getOption((String)"planner.memory.enable_memory_estimation").bool_val;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz == PlannerSettings.class) {
            return (T)this;
        }
        return null;
    }
}

