/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexUtil;

public abstract class JoinPrel
extends DrillJoinRelBase
implements Prel {
    public JoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitJoin(this, value);
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getLeft(), this.getRight());
    }

    public RelNode getJoinInput(int offset, RelNode input) {
        List<String> inputFields;
        assert (this.uniqueFieldNames(input.getRowType()));
        List<String> fields = this.getRowType().getFieldNames();
        List<String> outputFields = fields.subList(offset, offset + (inputFields = input.getRowType().getFieldNames()).size());
        if (!outputFields.equals(inputFields)) {
            return this.rename(input, input.getRowType().getFieldList(), outputFields);
        }
        return input;
    }

    private RelNode rename(RelNode input, List<RelDataTypeField> inputFields, List<String> outputFieldNames) {
        ArrayList<RexNode> exprs = Lists.newArrayList();
        for (RelDataTypeField field : inputFields) {
            RexInputRef expr = input.getCluster().getRexBuilder().makeInputRef(field.getType(), field.getIndex());
            exprs.add(expr);
        }
        RelDataType rowType = RexUtil.createStructType(input.getCluster().getTypeFactory(), exprs, outputFieldNames);
        ProjectPrel proj = new ProjectPrel(input.getCluster(), input.getTraitSet(), input, exprs, rowType);
        return proj;
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }
}

