/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import java.io.IOException;
import java.util.List;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashToMergeExchange;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.ExchangePrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.RelCollation;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;

public class HashToMergeExchangePrel
extends ExchangePrel {
    private final List<DrillDistributionTrait.DistributionField> distFields;
    private int numEndPoints = 0;
    private final RelCollation collation;

    public HashToMergeExchangePrel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<DrillDistributionTrait.DistributionField> fields, RelCollation collation, int numEndPoints) {
        super(cluster, traitSet, input);
        this.distFields = fields;
        this.collation = collation;
        this.numEndPoints = numEndPoints;
        assert (input.getConvention() == Prel.DRILL_PHYSICAL);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new HashToMergeExchangePrel(this.getCluster(), traitSet, HashToMergeExchangePrel.sole(inputs), this.distFields, this.collation, this.numEndPoints);
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        Prel child = (Prel)this.getChild();
        PhysicalOperator childPOP = child.getPhysicalOperator(creator);
        if (PrelUtil.getSettings(this.getCluster()).isSingleMode()) {
            return childPOP;
        }
        HashToMergeExchange g = new HashToMergeExchange(childPOP, PrelUtil.getHashExpression(this.distFields, this.getChild().getRowType()), PrelUtil.getOrdering(this.collation, this.getChild().getRowType()));
        return creator.addMetadata(this, g);
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

