/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.config.HashJoinPOP;
import org.apache.drill.exec.planner.physical.JoinPrel;
import org.apache.drill.exec.planner.physical.PhysicalPlanCreator;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.record.BatchSchema;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRelBase;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public class HashJoinPrel
extends JoinPrel {
    public HashJoinPrel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
        RelOptUtil.splitJoinCondition(left, right, condition, (List<Integer>)this.leftKeys, this.rightKeys);
    }

    @Override
    public JoinRelBase copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new HashJoinPrel(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public PhysicalOperator getPhysicalOperator(PhysicalPlanCreator creator) throws IOException {
        List<String> fields = this.getRowType().getFieldNames();
        assert (HashJoinPrel.isUnique(fields));
        int leftCount = this.left.getRowType().getFieldCount();
        List<String> leftFields = fields.subList(0, leftCount);
        List<String> rightFields = fields.subList(leftCount, fields.size());
        PhysicalOperator leftPop = ((Prel)this.left).getPhysicalOperator(creator);
        PhysicalOperator rightPop = ((Prel)this.right).getPhysicalOperator(creator);
        JoinRelType jtype = this.getJoinType();
        ArrayList<JoinCondition> conditions = Lists.newArrayList();
        for (Pair pair : Pair.zip(this.leftKeys, this.rightKeys)) {
            conditions.add(new JoinCondition("==", new FieldReference(leftFields.get((Integer)pair.left)), new FieldReference(rightFields.get((Integer)pair.right))));
        }
        HashJoinPOP hjoin = new HashJoinPOP(leftPop, rightPop, conditions, jtype);
        return creator.addMetadata(this, hjoin);
    }

    @Override
    public BatchSchema.SelectionVectorMode[] getSupportedEncodings() {
        return BatchSchema.SelectionVectorMode.DEFAULT;
    }

    @Override
    public BatchSchema.SelectionVectorMode getEncoding() {
        return BatchSchema.SelectionVectorMode.NONE;
    }
}

