/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.AggPrelBase;
import org.apache.drill.exec.planner.physical.AggPruleBase;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.apache.drill.exec.planner.physical.HashAggPrel;
import org.apache.drill.exec.planner.physical.HashToRandomExchangePrel;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.SubsetTransformer;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.trace.EigenbaseTrace;

public class HashAggPrule
extends AggPruleBase {
    public static final RelOptRule INSTANCE = new HashAggPrule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private HashAggPrule() {
        super(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(RelNode.class), new RelOptRuleOperand[0]), "HashAggPrule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        return settings.isMemoryEstimationEnabled() || settings.isHashAggEnabled();
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        if (!PrelUtil.getPlannerSettings(call.getPlanner()).isHashAggEnabled()) {
            return;
        }
        DrillAggregateRel aggregate = (DrillAggregateRel)call.rel(0);
        Object input = call.rel(1);
        if (aggregate.containsDistinctCall() || aggregate.getGroupCount() == 0) {
            return;
        }
        RelTraitSet traits = null;
        try {
            if (aggregate.getGroupSet().isEmpty()) {
                DrillDistributionTrait singleDist = DrillDistributionTrait.SINGLETON;
                traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(singleDist);
                this.createTransformRequest(call, aggregate, (RelNode)input, traits);
            } else {
                DrillDistributionTrait distOnAllKeys = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, true)));
                traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(distOnAllKeys);
                this.createTransformRequest(call, aggregate, (RelNode)input, traits);
                DrillDistributionTrait distOnOneKey = new DrillDistributionTrait(DrillDistributionTrait.DistributionType.HASH_DISTRIBUTED, ImmutableList.copyOf(this.getDistributionField(aggregate, false)));
                traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL).plus(distOnOneKey);
                this.createTransformRequest(call, aggregate, (RelNode)input, traits);
                if (this.create2PhasePlan(call, aggregate)) {
                    traits = call.getPlanner().emptyTraitSet().plus(Prel.DRILL_PHYSICAL);
                    RelNode convertedInput = HashAggPrule.convert(input, traits);
                    new TwoPhaseSubset(call, distOnAllKeys).go(aggregate, convertedInput);
                }
            }
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }

    private void createTransformRequest(RelOptRuleCall call, DrillAggregateRel aggregate, RelNode input, RelTraitSet traits) throws InvalidRelException {
        RelNode convertedInput = HashAggPrule.convert(input, PrelUtil.fixTraits(call, traits));
        HashAggPrel newAgg = new HashAggPrel(aggregate.getCluster(), traits, convertedInput, aggregate.getGroupSet(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of1);
        call.transformTo(newAgg);
    }

    private class TwoPhaseSubset
    extends SubsetTransformer<DrillAggregateRel, InvalidRelException> {
        final RelTrait distOnAllKeys;

        public TwoPhaseSubset(RelOptRuleCall call, RelTrait distOnAllKeys) {
            super(call);
            this.distOnAllKeys = distOnAllKeys;
        }

        @Override
        public RelNode convertChild(DrillAggregateRel aggregate, RelNode input) throws InvalidRelException {
            RelTraitSet traits = this.newTraitSet(Prel.DRILL_PHYSICAL, input.getTraitSet().getTrait(DrillDistributionTraitDef.INSTANCE));
            RelNode newInput = Prule.convert(input, traits);
            HashAggPrel phase1Agg = new HashAggPrel(aggregate.getCluster(), traits, newInput, aggregate.getGroupSet(), aggregate.getAggCallList(), AggPrelBase.OperatorPhase.PHASE_1of2);
            HashToRandomExchangePrel exch = new HashToRandomExchangePrel(phase1Agg.getCluster(), phase1Agg.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(this.distOnAllKeys), phase1Agg, ImmutableList.copyOf(HashAggPrule.this.getDistributionField(aggregate, true)));
            HashAggPrel phase2Agg = new HashAggPrel(aggregate.getCluster(), exch.getTraitSet(), exch, aggregate.getGroupSet(), phase1Agg.getPhase2AggCalls(), AggPrelBase.OperatorPhase.PHASE_2of2);
            return phase2Agg;
        }
    }
}

