/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.ImmutableList;
import org.apache.drill.exec.planner.physical.DrillDistributionTraitDef;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.relopt.RelTrait;
import org.eigenbase.relopt.RelTraitDef;

public class DrillDistributionTrait
implements RelTrait {
    public static DrillDistributionTrait SINGLETON = new DrillDistributionTrait(DistributionType.SINGLETON);
    public static DrillDistributionTrait RANDOM_DISTRIBUTED = new DrillDistributionTrait(DistributionType.RANDOM_DISTRIBUTED);
    public static DrillDistributionTrait ANY;
    public static DrillDistributionTrait DEFAULT;
    private DistributionType type;
    private final ImmutableList<DistributionField> fields;

    public DrillDistributionTrait(DistributionType type) {
        assert (type == DistributionType.SINGLETON || type == DistributionType.RANDOM_DISTRIBUTED || type == DistributionType.ANY || type == DistributionType.ROUND_ROBIN_DISTRIBUTED || type == DistributionType.BROADCAST_DISTRIBUTED);
        this.type = type;
        this.fields = ImmutableList.of();
    }

    public DrillDistributionTrait(DistributionType type, ImmutableList<DistributionField> fields) {
        assert (type == DistributionType.HASH_DISTRIBUTED || type == DistributionType.RANGE_DISTRIBUTED);
        this.type = type;
        this.fields = fields;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    @Override
    public boolean subsumes(RelTrait trait) {
        if (trait instanceof DrillDistributionTrait) {
            DistributionType requiredDist = ((DrillDistributionTrait)trait).getType();
            if (requiredDist == DistributionType.ANY) {
                return true;
            }
            if (this.type == DistributionType.HASH_DISTRIBUTED) {
                if (requiredDist == DistributionType.HASH_DISTRIBUTED) {
                    return this.equals(trait);
                }
                if (requiredDist == DistributionType.RANDOM_DISTRIBUTED) {
                    return true;
                }
            }
        }
        return this.equals(trait);
    }

    @Override
    public RelTraitDef<DrillDistributionTrait> getTraitDef() {
        return DrillDistributionTraitDef.INSTANCE;
    }

    public DistributionType getType() {
        return this.type;
    }

    public ImmutableList<DistributionField> getFields() {
        return this.fields;
    }

    public int hashCode() {
        return this.fields == null ? this.type.hashCode() : this.type.hashCode() | this.fields.hashCode() << 4;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DrillDistributionTrait) {
            DrillDistributionTrait that = (DrillDistributionTrait)obj;
            return this.type == that.type && this.fields.equals(that.fields);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.fields == null ? this.type.toString() : this.type.toString() + "(" + this.fields + ")";
    }

    static {
        DEFAULT = ANY = new DrillDistributionTrait(DistributionType.ANY);
    }

    public static class DistributionField {
        private final int fieldId;

        public DistributionField(int fieldId) {
            this.fieldId = fieldId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DistributionField)) {
                return false;
            }
            DistributionField other = (DistributionField)obj;
            return this.fieldId == other.fieldId;
        }

        public int hashCode() {
            return this.fieldId;
        }

        public int getFieldId() {
            return this.fieldId;
        }

        public String toString() {
            return String.format("[$%s]", this.fieldId);
        }
    }

    public static enum DistributionType {
        SINGLETON,
        HASH_DISTRIBUTED,
        RANGE_DISTRIBUTED,
        RANDOM_DISTRIBUTED,
        ROUND_ROBIN_DISTRIBUTED,
        BROADCAST_DISTRIBUTED,
        ANY;

    }
}

