/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.drill.common.expression.SchemaPath;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.logical.DrillProjectRel;
import org.apache.drill.exec.planner.logical.DrillScanRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.ProjectPrel;
import org.apache.drill.exec.planner.physical.Prule;
import org.apache.drill.exec.planner.physical.ScanPrel;
import org.apache.drill.exec.store.direct.DirectGroupScan;
import org.apache.drill.exec.store.pojo.PojoRecordReader;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.reltype.RelDataTypeField;
import org.eigenbase.reltype.RelDataTypeFieldImpl;
import org.eigenbase.reltype.RelRecordType;
import org.eigenbase.rex.RexInputRef;
import org.eigenbase.rex.RexNode;
import org.eigenbase.sql.type.SqlTypeName;

public class ConvertCountToDirectScan
extends Prule {
    public static final RelOptRule AGG_ON_PROJ_ON_SCAN = new ConvertCountToDirectScan(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.some(DrillProjectRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "Agg_on_proj_on_scan");
    public static final RelOptRule AGG_ON_SCAN = new ConvertCountToDirectScan(RelOptHelper.some(DrillAggregateRel.class, RelOptHelper.any(DrillScanRel.class), new RelOptRuleOperand[0]), "Agg_on_scan");

    protected ConvertCountToDirectScan(RelOptRuleOperand rule, String id) {
        super(rule, "ConvertCountToDirectScan:" + id);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        DrillAggregateRel agg = (DrillAggregateRel)call.rel(0);
        DrillScanRel scan = (DrillScanRel)call.rel(call.rels.length - 1);
        DrillProjectRel proj = call.rels.length == 3 ? (DrillProjectRel)call.rel(1) : null;
        GroupScan oldGrpScan = scan.getGroupScan();
        if (!oldGrpScan.getScanStats().getGroupScanProperty().hasExactRowCount() || agg.getGroupCount() != 0 || agg.getAggCallList().size() != 1 || agg.containsDistinctCall()) {
            return;
        }
        AggregateCall aggCall = agg.getAggCallList().get(0);
        if (aggCall.getAggregation().getName().equals("COUNT")) {
            long cnt = 0L;
            if (aggCall.getArgList().isEmpty() || aggCall.getArgList().size() == 1 && !agg.getChild().getRowType().getFieldList().get(aggCall.getArgList().get(0)).getType().isNullable()) {
                cnt = oldGrpScan.getScanStats().getRecordCount();
            } else if (aggCall.getArgList().size() == 1) {
                int index = aggCall.getArgList().get(0);
                String columnName = scan.getRowType().getFieldNames().get(index).toLowerCase();
                cnt = oldGrpScan.getColumnValueCount(SchemaPath.getSimplePath(columnName));
            } else {
                return;
            }
            RelDataType scanRowType = this.getCountDirectScanRowType(agg.getCluster().getTypeFactory());
            ScanPrel newScan = ScanPrel.create(scan, scan.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(DrillDistributionTrait.SINGLETON), this.getCountDirectScan(cnt), scanRowType);
            ArrayList<RexNode> exprs = Lists.newArrayList();
            exprs.add(RexInputRef.of(0, scanRowType));
            ProjectPrel newProj = new ProjectPrel(agg.getCluster(), agg.getTraitSet().plus(Prel.DRILL_PHYSICAL).plus(DrillDistributionTrait.SINGLETON), newScan, exprs, agg.getRowType());
            call.transformTo(newProj);
        }
    }

    private RelDataType getCountDirectScanRowType(RelDataTypeFactory typeFactory) {
        ArrayList<RelDataTypeField> fields = Lists.newArrayList();
        fields.add(new RelDataTypeFieldImpl("count", 0, typeFactory.createSqlType(SqlTypeName.BIGINT)));
        return new RelRecordType((List<RelDataTypeField>)fields);
    }

    private GroupScan getCountDirectScan(long cnt) {
        CountQueryResult res = new CountQueryResult(cnt);
        PojoRecordReader<CountQueryResult> reader = new PojoRecordReader<CountQueryResult>(CountQueryResult.class, Collections.singleton(res).iterator());
        return new DirectGroupScan(reader);
    }

    public static class CountQueryResult {
        public Long count;

        public CountQueryResult(long cnt) {
            this.count = cnt;
        }
    }
}

