/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.exec.planner.logical.DrillAggregateRel;
import org.apache.drill.exec.planner.physical.DrillDistributionTrait;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.Prule;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelOptRuleOperand;

public abstract class AggPruleBase
extends Prule {
    protected AggPruleBase(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected List<DrillDistributionTrait.DistributionField> getDistributionField(DrillAggregateRel rel, boolean allFields) {
        ArrayList<DrillDistributionTrait.DistributionField> groupByFields = Lists.newArrayList();
        for (int group : BitSets.toIter(rel.getGroupSet())) {
            DrillDistributionTrait.DistributionField field = new DrillDistributionTrait.DistributionField(group);
            groupByFields.add(field);
            if (allFields || groupByFields.size() != 1) continue;
            break;
        }
        return groupByFields;
    }

    protected boolean create2PhasePlan(RelOptRuleCall call, DrillAggregateRel aggregate) {
        boolean smallInput;
        PlannerSettings settings = PrelUtil.getPlannerSettings(call.getPlanner());
        RelNode child = call.rel(0).getInputs().get(0);
        boolean bl = smallInput = child.getRows() < (double)settings.getSliceTarget();
        if (!settings.isMultiPhaseAggEnabled() || settings.isSingleMode() || smallInput) {
            return false;
        }
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            String name = aggCall.getAggregation().getName();
            if (name.equals("SUM") || name.equals("MIN") || name.equals("MAX") || name.equals("COUNT") || name.equals("$SUM0")) continue;
            return false;
        }
        return true;
    }
}

