/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.physical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCall;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.physical.Prel;
import org.apache.drill.exec.planner.physical.PrelUtil;
import org.apache.drill.exec.planner.physical.visitor.PrelVisitor;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.sql.SqlAggFunction;
import org.eigenbase.sql.SqlFunctionCategory;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.type.OperandTypes;
import org.eigenbase.sql.type.ReturnTypes;

public abstract class AggPrelBase
extends AggregateRelBase
implements Prel {
    protected OperatorPhase operPhase = OperatorPhase.PHASE_1of1;
    protected List<NamedExpression> keys = Lists.newArrayList();
    protected List<NamedExpression> aggExprs = Lists.newArrayList();
    protected List<AggregateCall> phase2AggCallList = Lists.newArrayList();

    public AggPrelBase(RelOptCluster cluster, RelTraitSet traits, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls, OperatorPhase phase) throws InvalidRelException {
        super(cluster, traits, child, groupSet, aggCalls);
        this.operPhase = phase;
        this.createKeysAndExprs();
    }

    public OperatorPhase getOperatorPhase() {
        return this.operPhase;
    }

    public List<AggregateCall> getPhase2AggCalls() {
        return this.phase2AggCallList;
    }

    protected void createKeysAndExprs() {
        List<String> childFields = this.getChild().getRowType().getFieldNames();
        List<String> fields = this.getRowType().getFieldNames();
        Iterator<Object> i$ = BitSets.toIter(this.groupSet).iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            FieldReference fr = new FieldReference((CharSequence)childFields.get(n), ExpressionPosition.UNKNOWN);
            this.keys.add(new NamedExpression(fr, fr));
        }
        for (Ord ord : Ord.zip(this.aggCalls)) {
            int aggExprOrdinal = this.groupSet.cardinality() + ord.i;
            FieldReference ref = new FieldReference(fields.get(aggExprOrdinal));
            LogicalExpression expr = this.toDrill((AggregateCall)ord.e, childFields, new DrillParseContext());
            NamedExpression ne = new NamedExpression(expr, ref);
            this.aggExprs.add(ne);
            if (this.getOperatorPhase() != OperatorPhase.PHASE_1of2) continue;
            if (((AggregateCall)ord.e).getAggregation().getName().equals("COUNT")) {
                SqlSumCountAggFunction sumAggFun = new SqlSumCountAggFunction(((AggregateCall)ord.e).getType());
                AggregateCall newAggCall = new AggregateCall(sumAggFun, ((AggregateCall)ord.e).isDistinct(), Collections.singletonList(aggExprOrdinal), ((AggregateCall)ord.e).getType(), ((AggregateCall)ord.e).getName());
                this.phase2AggCallList.add(newAggCall);
                continue;
            }
            AggregateCall newAggCall = new AggregateCall(((AggregateCall)ord.e).getAggregation(), ((AggregateCall)ord.e).isDistinct(), Collections.singletonList(aggExprOrdinal), ((AggregateCall)ord.e).getType(), ((AggregateCall)ord.e).getName());
            this.phase2AggCallList.add(newAggCall);
        }
    }

    protected LogicalExpression toDrill(AggregateCall call, List<String> fn, DrillParseContext pContext) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        FunctionCall expr = new FunctionCall(call.getAggregation().getName().toLowerCase(), args, ExpressionPosition.UNKNOWN);
        return expr;
    }

    @Override
    public Iterator<Prel> iterator() {
        return PrelUtil.iter(this.getChild());
    }

    @Override
    public <T, X, E extends Throwable> T accept(PrelVisitor<T, X, E> logicalVisitor, X value) throws E {
        return logicalVisitor.visitPrel(this, value);
    }

    @Override
    public boolean needsFinalColumnReordering() {
        return true;
    }

    public class SqlSumCountAggFunction
    extends SqlAggFunction {
        private final RelDataType type;

        public SqlSumCountAggFunction(RelDataType type) {
            super("$SUM0", SqlKind.OTHER_FUNCTION, ReturnTypes.BIGINT, null, OperandTypes.NUMERIC, SqlFunctionCategory.NUMERIC);
            this.type = type;
        }

        @Override
        public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
            return this.type;
        }
    }

    protected static enum OperatorPhase {
        PHASE_1of1,
        PHASE_1of2,
        PHASE_2of2;

    }
}

