/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.ArrayList;
import java.util.logging.Logger;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillUnionRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.trace.EigenbaseTrace;

public class DrillUnionRule
extends RelOptRule {
    public static final RelOptRule INSTANCE = new DrillUnionRule();
    protected static final Logger tracer = EigenbaseTrace.getPlannerTracer();

    private DrillUnionRule() {
        super(RelOptHelper.any(UnionRel.class, Convention.NONE), "DrillUnionRule");
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        UnionRel union = (UnionRel)call.rel(0);
        RelTraitSet traits = union.getTraitSet().plus(DrillRel.DRILL_LOGICAL);
        ArrayList<RelNode> convertedInputs = new ArrayList<RelNode>();
        for (RelNode input : union.getInputs()) {
            RelNode convertedInput = DrillUnionRule.convert(input, input.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
            convertedInputs.add(convertedInput);
        }
        try {
            call.transformTo(new DrillUnionRel(union.getCluster(), traits, convertedInputs, union.all));
        }
        catch (InvalidRelException e) {
            tracer.warning(e.toString());
        }
    }
}

