/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.io.IOException;
import net.hydromatic.optiq.Schema;
import net.hydromatic.optiq.Statistic;
import net.hydromatic.optiq.Statistics;
import net.hydromatic.optiq.Table;
import org.apache.drill.common.JSONOptions;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.store.StoragePlugin;

public abstract class DrillTable
implements Table {
    private final String storageEngineName;
    public final StoragePluginConfig storageEngineConfig;
    private Object selection;
    private StoragePlugin plugin;
    private GroupScan scan;

    public DrillTable(String storageEngineName, StoragePlugin plugin, Object selection) {
        this.selection = selection;
        this.plugin = plugin;
        this.storageEngineConfig = plugin.getConfig();
        this.storageEngineName = storageEngineName;
    }

    public GroupScan getGroupScan() throws IOException {
        if (this.scan == null) {
            this.scan = this.plugin.getPhysicalScan(new JSONOptions(this.selection));
        }
        return this.scan;
    }

    public StoragePluginConfig getStorageEngineConfig() {
        return this.storageEngineConfig;
    }

    public Object getSelection() {
        return this.selection;
    }

    public String getStorageEngineName() {
        return this.storageEngineName;
    }

    @Override
    public Statistic getStatistic() {
        return Statistics.UNKNOWN;
    }

    @Override
    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.TABLE;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.selection == null ? 0 : this.selection.hashCode());
        result = 31 * result + (this.storageEngineConfig == null ? 0 : this.storageEngineConfig.hashCode());
        result = 31 * result + (this.storageEngineName == null ? 0 : this.storageEngineName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DrillTable other = (DrillTable)obj;
        if (this.selection == null ? other.selection != null : !this.selection.equals(other.selection)) {
            return false;
        }
        if (this.storageEngineConfig == null ? other.storageEngineConfig != null : !this.storageEngineConfig.equals(other.storageEngineConfig)) {
            return false;
        }
        return !(this.storageEngineName == null ? other.storageEngineName != null : !this.storageEngineName.equals(other.storageEngineName));
    }
}

