/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Iterator;
import net.hydromatic.optiq.tools.RuleSet;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.planner.logical.DrillAggregateRule;
import org.apache.drill.exec.planner.logical.DrillFilterRule;
import org.apache.drill.exec.planner.logical.DrillJoinRule;
import org.apache.drill.exec.planner.logical.DrillLimitRule;
import org.apache.drill.exec.planner.logical.DrillMergeProjectRule;
import org.apache.drill.exec.planner.logical.DrillProjectRule;
import org.apache.drill.exec.planner.logical.DrillPushProjIntoScan;
import org.apache.drill.exec.planner.logical.DrillPushProjectPastFilterRule;
import org.apache.drill.exec.planner.logical.DrillReduceAggregatesRule;
import org.apache.drill.exec.planner.logical.DrillScanRule;
import org.apache.drill.exec.planner.logical.DrillSortRule;
import org.apache.drill.exec.planner.logical.DrillUnionRule;
import org.apache.drill.exec.planner.physical.ConvertCountToDirectScan;
import org.apache.drill.exec.planner.physical.FilterPrule;
import org.apache.drill.exec.planner.physical.HashAggPrule;
import org.apache.drill.exec.planner.physical.HashJoinPrule;
import org.apache.drill.exec.planner.physical.LimitPrule;
import org.apache.drill.exec.planner.physical.MergeJoinPrule;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.planner.physical.ProjectPrule;
import org.apache.drill.exec.planner.physical.PushLimitToTopN;
import org.apache.drill.exec.planner.physical.ScanPrule;
import org.apache.drill.exec.planner.physical.ScreenPrule;
import org.apache.drill.exec.planner.physical.SortConvertPrule;
import org.apache.drill.exec.planner.physical.SortPrule;
import org.apache.drill.exec.planner.physical.StreamAggPrule;
import org.apache.drill.exec.planner.physical.UnionAllPrule;
import org.apache.drill.exec.planner.physical.WriterPrule;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.rules.PushFilterPastJoinRule;
import org.eigenbase.rel.rules.PushFilterPastProjectRule;
import org.eigenbase.rel.rules.PushJoinThroughJoinRule;
import org.eigenbase.rel.rules.PushProjectPastJoinRule;
import org.eigenbase.rel.rules.RemoveDistinctAggregateRule;
import org.eigenbase.rel.rules.RemoveDistinctRule;
import org.eigenbase.rel.rules.RemoveSortRule;
import org.eigenbase.rel.rules.RemoveTrivialProjectRule;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.volcano.AbstractConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillRuleSets {
    static final Logger logger = LoggerFactory.getLogger(DrillRuleSets.class);
    public static RuleSet DRILL_BASIC_RULES = null;
    public static final RuleSet DRILL_PHYSICAL_DISK = new DrillRuleSet(ImmutableSet.of(ProjectPrule.INSTANCE));

    public static RuleSet getDrillBasicRules(QueryContext context) {
        if (DRILL_BASIC_RULES == null) {
            DRILL_BASIC_RULES = new DrillRuleSet(ImmutableSet.of(PushFilterPastProjectRule.INSTANCE, PushFilterPastJoinRule.FILTER_ON_JOIN, PushFilterPastJoinRule.JOIN, PushJoinThroughJoinRule.RIGHT, PushJoinThroughJoinRule.LEFT, AbstractConverter.ExpandConversionRule.INSTANCE, new RelOptRule[]{RemoveDistinctRule.INSTANCE, RemoveTrivialProjectRule.INSTANCE, RemoveSortRule.INSTANCE, DrillMergeProjectRule.getInstance(true, RelFactories.DEFAULT_PROJECT_FACTORY, context.getFunctionRegistry()), RemoveDistinctAggregateRule.INSTANCE, PushProjectPastJoinRule.INSTANCE, DrillPushProjectPastFilterRule.INSTANCE, DrillPushProjIntoScan.INSTANCE, DrillScanRule.INSTANCE, DrillFilterRule.INSTANCE, DrillProjectRule.INSTANCE, DrillAggregateRule.INSTANCE, DrillLimitRule.INSTANCE, DrillSortRule.INSTANCE, DrillJoinRule.INSTANCE, DrillUnionRule.INSTANCE, DrillReduceAggregatesRule.INSTANCE}));
        }
        return DRILL_BASIC_RULES;
    }

    public static final RuleSet getPhysicalRules(QueryContext qcontext) {
        ArrayList<RelOptRule> ruleList = new ArrayList<RelOptRule>();
        ruleList.add(ConvertCountToDirectScan.AGG_ON_PROJ_ON_SCAN);
        ruleList.add(ConvertCountToDirectScan.AGG_ON_SCAN);
        ruleList.add(SortConvertPrule.INSTANCE);
        ruleList.add(SortPrule.INSTANCE);
        ruleList.add(ProjectPrule.INSTANCE);
        ruleList.add(ScanPrule.INSTANCE);
        ruleList.add(ScreenPrule.INSTANCE);
        ruleList.add(AbstractConverter.ExpandConversionRule.INSTANCE);
        ruleList.add(FilterPrule.INSTANCE);
        ruleList.add(LimitPrule.INSTANCE);
        ruleList.add(WriterPrule.INSTANCE);
        ruleList.add(PushLimitToTopN.INSTANCE);
        ruleList.add(UnionAllPrule.INSTANCE);
        PlannerSettings ps = qcontext.getPlannerSettings();
        if (ps.isHashAggEnabled()) {
            ruleList.add(HashAggPrule.INSTANCE);
        }
        if (ps.isStreamAggEnabled()) {
            ruleList.add(StreamAggPrule.INSTANCE);
        }
        if (ps.isHashJoinEnabled()) {
            ruleList.add(HashJoinPrule.INSTANCE);
        }
        if (ps.isMergeJoinEnabled()) {
            ruleList.add(MergeJoinPrule.INSTANCE);
        }
        return new DrillRuleSet(ImmutableSet.copyOf(ruleList));
    }

    public static RuleSet create(ImmutableSet<RelOptRule> rules) {
        return new DrillRuleSet(rules);
    }

    public static RuleSet mergedRuleSets(RuleSet ... ruleSets) {
        ImmutableSet.Builder relOptRuleSetBuilder = ImmutableSet.builder();
        for (RuleSet ruleSet : ruleSets) {
            for (RelOptRule relOptRule : ruleSet) {
                relOptRuleSetBuilder.add(relOptRule);
            }
        }
        return new DrillRuleSet(relOptRuleSetBuilder.build());
    }

    private static class DrillRuleSet
    implements RuleSet {
        final ImmutableSet<RelOptRule> rules;

        public DrillRuleSet(ImmutableSet<RelOptRule> rules) {
            this.rules = rules;
        }

        @Override
        public Iterator<RelOptRule> iterator() {
            return this.rules.iterator();
        }
    }
}

