/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.FilterRel;
import org.eigenbase.rel.ProjectRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.rules.PushProjector;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;
import org.eigenbase.rex.RexOver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillPushProjectPastFilterRule
extends RelOptRule {
    private static final Logger logger = LoggerFactory.getLogger(DrillPushProjectPastFilterRule.class);
    public static final RelOptRule INSTANCE = new DrillPushProjectPastFilterRule(new PushProjector.ExprCondition(){

        @Override
        public boolean test(RexNode expr) {
            if (expr instanceof RexCall) {
                RexCall call = (RexCall)expr;
                return "ITEM".equals(call.getOperator().getName());
            }
            return false;
        }
    });
    private final PushProjector.ExprCondition preserveExprCondition;

    private DrillPushProjectPastFilterRule(PushProjector.ExprCondition preserveExprCondition) {
        super(RelOptHelper.any(ProjectRel.class, FilterRel.class));
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        FilterRel filterRel;
        ProjectRel origProj;
        if (call.rels.length == 2) {
            origProj = (ProjectRel)call.rel(0);
            filterRel = (FilterRel)call.rel(1);
        } else {
            origProj = null;
            filterRel = (FilterRel)call.rel(0);
        }
        RelNode rel = filterRel.getChild();
        RexNode origFilter = filterRel.getCondition();
        if (origProj != null && RexOver.containsOver(origProj.getProjects(), null)) {
            return;
        }
        PushProjector pushProjector = this.createPushProjector(origProj, origFilter, rel, this.preserveExprCondition);
        RelNode topProject = pushProjector.convertProject(null);
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }

    protected PushProjector createPushProjector(ProjectRel origProj, RexNode origFilter, RelNode rel, PushProjector.ExprCondition preserveExprCondition) {
        return new PushProjector(origProj, origFilter, rel, preserveExprCondition);
    }
}

