/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.drill.exec.expr.fn.FunctionImplementationRegistry;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelFactories;
import org.eigenbase.rel.rules.MergeProjectRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.rex.RexCall;
import org.eigenbase.rex.RexNode;

public class DrillMergeProjectRule
extends MergeProjectRule {
    private FunctionImplementationRegistry functionRegistry;
    private static DrillMergeProjectRule INSTANCE = null;

    public static DrillMergeProjectRule getInstance(boolean force, RelFactories.ProjectFactory pFactory, FunctionImplementationRegistry functionRegistry) {
        if (INSTANCE == null) {
            INSTANCE = new DrillMergeProjectRule(force, pFactory, functionRegistry);
        }
        return INSTANCE;
    }

    private DrillMergeProjectRule(boolean force, RelFactories.ProjectFactory pFactory, FunctionImplementationRegistry functionRegistry) {
        super(force, pFactory);
        this.functionRegistry = functionRegistry;
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        ProjectRelBase topProject = (ProjectRelBase)call.rel(0);
        ProjectRelBase bottomProject = (ProjectRelBase)call.rel(1);
        return !this.checkComplexOutput(topProject) && !this.checkComplexOutput(bottomProject);
    }

    private boolean checkComplexOutput(ProjectRelBase project) {
        for (RexNode expr : project.getChildExps()) {
            if (!(expr instanceof RexCall) || !this.functionRegistry.isFunctionComplexOutput(((RexCall)expr).getOperator().getName())) continue;
            return true;
        }
        return false;
    }
}

