/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import org.apache.drill.exec.planner.logical.DrillLimitRel;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.RelOptHelper;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.SortRel;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.relopt.RelTraitSet;

public class DrillLimitRule
extends RelOptRule {
    public static DrillLimitRule INSTANCE = new DrillLimitRule();

    private DrillLimitRule() {
        super(RelOptHelper.any(SortRel.class, Convention.NONE), "DrillLimitRule");
    }

    @Override
    public boolean matches(RelOptRuleCall call) {
        SortRel sort = (SortRel)call.rel(0);
        return sort.offset != null || sort.fetch != null;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        SortRel incomingSort = (SortRel)call.rel(0);
        RelTraitSet incomingTraits = incomingSort.getTraitSet();
        RelNode input = incomingSort.getChild();
        if (!incomingSort.getCollation().getFieldCollations().isEmpty()) {
            input = incomingSort.copy(incomingTraits, input, incomingSort.getCollation(), null, null);
        }
        RelNode convertedInput = DrillLimitRule.convert(input, input.getTraitSet().plus(DrillRel.DRILL_LOGICAL));
        call.transformTo(new DrillLimitRel(incomingSort.getCluster(), convertedInput.getTraitSet().plus(DrillRel.DRILL_LOGICAL), convertedInput, incomingSort.offset, incomingSort.fetch));
    }
}

