/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import java.util.List;
import org.apache.drill.common.logical.data.Limit;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.common.DrillLimitRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexLiteral;
import org.eigenbase.rex.RexNode;

public class DrillLimitRel
extends DrillLimitRelBase
implements DrillRel {
    public DrillLimitRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexNode offset, RexNode fetch) {
        super(cluster, traitSet, child, offset, fetch);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DrillLimitRel(this.getCluster(), traitSet, DrillLimitRel.sole(inputs), this.offset, this.fetch);
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        LogicalOperator inputOp = implementor.visitChild(this, 0, this.getChild());
        int first = this.offset != null ? Math.max(0, RexLiteral.intValue(this.offset)) : 0;
        Integer last = this.fetch != null ? Integer.valueOf(Math.max(0, RexLiteral.intValue(this.fetch)) + first) : null;
        Limit limit = new Limit(first, last);
        limit.setInput(inputOp);
        return limit;
    }
}

