/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.logical.data.Join;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.Project;
import org.apache.drill.exec.planner.common.DrillJoinRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.JoinRelType;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptUtil;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public class DrillJoinRel
extends DrillJoinRelBase
implements DrillRel {
    public DrillJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
        RexNode remaining = RelOptUtil.splitJoinCondition(left, right, condition, (List<Integer>)this.leftKeys, this.rightKeys);
        if (!(remaining.isAlwaysTrue() || this.leftKeys.size() != 0 && this.rightKeys.size() != 0)) {
            throw new InvalidRelException("DrillJoinRel only supports equi-join");
        }
    }

    public DrillJoinRel(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, List<Integer> leftKeys, List<Integer> rightKeys, boolean checkCartesian) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType);
        ArrayList<Integer> tmpRightKeys;
        ArrayList<Integer> tmpLeftKeys;
        RexNode remaining;
        assert (leftKeys != null && rightKeys != null);
        if (checkCartesian && !(remaining = RelOptUtil.splitJoinCondition(left, right, condition, tmpLeftKeys = Lists.newArrayList(), tmpRightKeys = Lists.newArrayList())).isAlwaysTrue() && (tmpLeftKeys.size() == 0 || tmpRightKeys.size() == 0)) {
            throw new InvalidRelException("DrillJoinRel only supports equi-join");
        }
        this.leftKeys = leftKeys;
        this.rightKeys = rightKeys;
    }

    @Override
    public DrillJoinRel copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new DrillJoinRel(this.getCluster(), traitSet, left, right, condition, joinType);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        List<String> fields = this.getRowType().getFieldNames();
        assert (DrillJoinRel.isUnique(fields));
        int leftCount = this.left.getRowType().getFieldCount();
        List<String> leftFields = fields.subList(0, leftCount);
        List<String> rightFields = fields.subList(leftCount, fields.size());
        LogicalOperator leftOp = this.implementInput(implementor, 0, 0, this.left);
        LogicalOperator rightOp = this.implementInput(implementor, 1, leftCount, this.right);
        Join.Builder builder = Join.builder();
        builder.type(this.joinType);
        builder.left(leftOp);
        builder.right(rightOp);
        for (Pair pair : Pair.zip(this.leftKeys, this.rightKeys)) {
            builder.addCondition("==", new FieldReference(leftFields.get((Integer)pair.left)), new FieldReference(rightFields.get((Integer)pair.right)));
        }
        return builder.build();
    }

    private LogicalOperator implementInput(DrillImplementor implementor, int i, int offset, RelNode input) {
        List<String> inputFields;
        LogicalOperator inputOp = implementor.visitChild(this, i, input);
        assert (this.uniqueFieldNames(input.getRowType()));
        List<String> fields = this.getRowType().getFieldNames();
        List<String> outputFields = fields.subList(offset, offset + (inputFields = input.getRowType().getFieldNames()).size());
        if (!outputFields.equals(inputFields)) {
            return this.rename(implementor, inputOp, inputFields, outputFields);
        }
        return inputOp;
    }

    private LogicalOperator rename(DrillImplementor implementor, LogicalOperator inputOp, List<String> inputFields, List<String> outputFields) {
        Project.Builder builder = Project.builder();
        builder.setInput(inputOp);
        for (Pair<String, String> pair : Pair.zip(inputFields, outputFields)) {
            builder.addExpr(new FieldReference((CharSequence)pair.right), new FieldReference((CharSequence)pair.left));
        }
        return builder.build();
    }
}

