/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.logical.LogicalPlanBuilder;
import org.apache.drill.common.logical.PlanProperties;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.common.logical.data.visitors.AbstractLogicalVisitor;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.apache.drill.exec.planner.logical.DrillTable;
import org.eigenbase.rel.RelNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrillImplementor {
    static final Logger logger = LoggerFactory.getLogger(DrillImplementor.class);
    private Set<DrillTable> tables = Sets.newHashSet();
    private Set<String> storageEngineNames = Sets.newHashSet();
    private LogicalPlanBuilder planBuilder = new LogicalPlanBuilder();
    private LogicalPlan plan;
    private final DrillParseContext context;

    public DrillImplementor(DrillParseContext context, PlanProperties.Generator.ResultMode mode) {
        this.planBuilder.planProperties(PlanProperties.PlanType.APACHE_DRILL_LOGICAL, 1, DrillImplementor.class.getName(), "", mode);
        this.context = context;
    }

    public DrillParseContext getContext() {
        return this.context;
    }

    public void registerSource(DrillTable table) {
        if (this.tables.add(table) && this.storageEngineNames.add(table.getStorageEngineName())) {
            this.planBuilder.addStorageEngine(table.getStorageEngineName(), table.getStorageEngineConfig());
        }
    }

    public void go(DrillRel root) {
        LogicalOperator rootLOP = root.implement(this);
        rootLOP.accept(new AddOpsVisitor(), null);
    }

    public LogicalPlan getPlan() {
        if (this.plan == null) {
            this.plan = this.planBuilder.build();
            this.planBuilder = null;
        }
        return this.plan;
    }

    public LogicalOperator visitChild(DrillRel parent, int ordinal, RelNode child) {
        return ((DrillRel)child).implement(this);
    }

    private class AddOpsVisitor
    extends AbstractLogicalVisitor<Void, Void, RuntimeException> {
        private AddOpsVisitor() {
        }

        @Override
        public Void visitOp(LogicalOperator op, Void value) throws RuntimeException {
            DrillImplementor.this.planBuilder.addLogicalOperator(op);
            for (LogicalOperator o : op) {
                o.accept(this, null);
            }
            return null;
        }
    }
}

