/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.logical;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import net.hydromatic.linq4j.Ord;
import net.hydromatic.optiq.util.BitSets;
import org.apache.drill.common.expression.ExpressionPosition;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.FunctionCallFactory;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.expression.ValueExpressions;
import org.apache.drill.common.logical.data.GroupingAggregate;
import org.apache.drill.common.logical.data.LogicalOperator;
import org.apache.drill.exec.planner.common.DrillAggregateRelBase;
import org.apache.drill.exec.planner.logical.DrillImplementor;
import org.apache.drill.exec.planner.logical.DrillRel;
import org.eigenbase.rel.AggregateCall;
import org.eigenbase.rel.AggregateRelBase;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;

public class DrillAggregateRel
extends DrillAggregateRelBase
implements DrillRel {
    public DrillAggregateRel(RelOptCluster cluster, RelTraitSet traits, RelNode child, BitSet groupSet, List<AggregateCall> aggCalls) throws InvalidRelException {
        super(cluster, traits, child, groupSet, aggCalls);
    }

    @Override
    public AggregateRelBase copy(RelTraitSet traitSet, RelNode input, BitSet groupSet, List<AggregateCall> aggCalls) {
        try {
            return new DrillAggregateRel(this.getCluster(), traitSet, input, this.getGroupSet(), aggCalls);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public LogicalOperator implement(DrillImplementor implementor) {
        GroupingAggregate.Builder builder = GroupingAggregate.builder();
        builder.setInput(implementor.visitChild(this, 0, this.getChild()));
        List<String> childFields = this.getChild().getRowType().getFieldNames();
        List<String> fields = this.getRowType().getFieldNames();
        Iterator<Object> i$ = BitSets.toIter(this.groupSet).iterator();
        while (i$.hasNext()) {
            int n = i$.next();
            FieldReference fr = new FieldReference((CharSequence)childFields.get(n), ExpressionPosition.UNKNOWN);
            builder.addKey(fr, fr);
        }
        for (Ord ord : Ord.zip(this.aggCalls)) {
            FieldReference ref = new FieldReference(fields.get(this.groupSet.cardinality() + ord.i));
            LogicalExpression expr = this.toDrill((AggregateCall)ord.e, childFields, implementor);
            builder.addExpr(ref, expr);
        }
        return builder.build();
    }

    private LogicalExpression toDrill(AggregateCall call, List<String> fn, DrillImplementor implementor) {
        ArrayList<LogicalExpression> args = Lists.newArrayList();
        for (Integer i : call.getArgList()) {
            args.add(new FieldReference(fn.get(i)));
        }
        if (args.isEmpty()) {
            args.add(new ValueExpressions.LongExpression(1L));
        }
        LogicalExpression expr = FunctionCallFactory.createExpression(call.getAggregation().getName().toLowerCase(), ExpressionPosition.UNKNOWN, args);
        return expr;
    }
}

