/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.EndpointAffinity;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.Exchange;
import org.apache.drill.exec.physical.base.GroupScan;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Store;
import org.apache.drill.exec.physical.base.SubScan;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wrapper {
    static final Logger logger = LoggerFactory.getLogger(Wrapper.class);
    private final Fragment node;
    private final int majorFragmentId;
    private int width = -1;
    private final Stats stats;
    private boolean endpointsAssigned;
    private Map<CoordinationProtos.DrillbitEndpoint, EndpointAffinity> endpointAffinityMap = Maps.newHashMap();
    private long initialAllocation = 0L;
    private long maxAllocation = 0L;
    private List<CoordinationProtos.DrillbitEndpoint> endpoints = Lists.newLinkedList();

    public Wrapper(Fragment node, int majorFragmentId) {
        this.majorFragmentId = majorFragmentId;
        this.node = node;
        this.stats = new Stats();
    }

    public Stats getStats() {
        return this.stats;
    }

    public void resetAllocation() {
        this.initialAllocation = 0L;
        this.maxAllocation = 0L;
    }

    public void addEndpointAffinity(List<EndpointAffinity> affinities) {
        Preconditions.checkState(!this.endpointsAssigned);
        for (EndpointAffinity ea : affinities) {
            this.addEndpointAffinity(ea.getEndpoint(), ea.getAffinity());
        }
    }

    public void addEndpointAffinity(CoordinationProtos.DrillbitEndpoint endpoint, float affinity) {
        Preconditions.checkState(!this.endpointsAssigned);
        Preconditions.checkNotNull(endpoint);
        EndpointAffinity ea = this.endpointAffinityMap.get(endpoint);
        if (ea == null) {
            ea = new EndpointAffinity(endpoint);
            this.endpointAffinityMap.put(endpoint, ea);
        }
        ea.addAffinity(affinity);
    }

    public int getMajorFragmentId() {
        return this.majorFragmentId;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        Preconditions.checkState(this.width == -1);
        this.width = width;
    }

    public Fragment getNode() {
        return this.node;
    }

    public long getInitialAllocation() {
        return this.initialAllocation;
    }

    public long getMaxAllocation() {
        return this.maxAllocation;
    }

    public void addAllocation(PhysicalOperator pop) {
        this.initialAllocation += pop.getInitialAllocation();
        logger.debug("Incrementing initialAllocation by {} to {}. Pop: {}", pop.getInitialAllocation(), this.initialAllocation, pop);
        this.maxAllocation += pop.getMaxAllocation();
    }

    public void assignEndpoints(Collection<CoordinationProtos.DrillbitEndpoint> allEndpoints, double affinityFactor) throws PhysicalOperatorSetupException {
        Preconditions.checkState(!this.endpointsAssigned);
        this.endpointsAssigned = true;
        if (this.endpointAffinityMap.size() > 0) {
            ArrayList<EndpointAffinity> affinedEPs = Lists.newArrayList(this.endpointAffinityMap.values());
            Collections.sort(affinedEPs);
            Iterator<EndpointAffinity> affinedEPItr = Iterators.cycle(Lists.reverse(affinedEPs));
            int affinedSlots = Math.min(Math.max(1, (int)(affinityFactor * (double)this.width / (double)allEndpoints.size())) * affinedEPs.size(), this.width);
            while (this.endpoints.size() < affinedSlots) {
                EndpointAffinity ea = affinedEPItr.next();
                CoordinationProtos.DrillbitEndpoint endpoint = ea.getEndpoint();
                this.endpoints.add(endpoint);
            }
        }
        if (this.endpoints.size() < this.width) {
            ArrayList<CoordinationProtos.DrillbitEndpoint> all = Lists.newArrayList(allEndpoints);
            all.removeAll(this.endpointAffinityMap.keySet());
            Collections.shuffle(all, ThreadLocalRandom.current());
            Iterator<CoordinationProtos.DrillbitEndpoint> otherEPItr = Iterators.cycle(all.size() > 0 ? all : this.endpointAffinityMap.keySet());
            while (this.endpoints.size() < this.width) {
                this.endpoints.add(otherEPItr.next());
            }
        }
        AssignEndpointsToScanAndStore visitor = new AssignEndpointsToScanAndStore();
        this.node.getRoot().accept(visitor, this.endpoints);
        if (this.node.getSendingExchange() != null) {
            this.node.getSendingExchange().setupSenders(this.majorFragmentId, this.endpoints);
        }
        for (Fragment.ExchangeFragmentPair e : this.node.getReceivingExchangePairs()) {
            e.getExchange().setupReceivers(this.majorFragmentId, this.endpoints);
        }
    }

    public String toString() {
        return "FragmentWrapper [majorFragmentId=" + this.majorFragmentId + ", width=" + this.width + ", stats=" + this.stats + "]";
    }

    public CoordinationProtos.DrillbitEndpoint getAssignedEndpoint(int minorFragmentId) {
        Preconditions.checkState(this.endpointsAssigned);
        return this.endpoints.get(minorFragmentId);
    }

    private class AssignEndpointsToScanAndStore
    extends AbstractPhysicalVisitor<Void, List<CoordinationProtos.DrillbitEndpoint>, PhysicalOperatorSetupException> {
        private AssignEndpointsToScanAndStore() {
        }

        @Override
        public Void visitExchange(Exchange exchange, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            if (exchange == Wrapper.this.node.getSendingExchange()) {
                return this.visitOp((PhysicalOperator)exchange, value);
            }
            return null;
        }

        @Override
        public Void visitGroupScan(GroupScan groupScan, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            groupScan.applyAssignments(value);
            return (Void)super.visitGroupScan(groupScan, value);
        }

        @Override
        public Void visitSubScan(SubScan subScan, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            return this.visitOp((PhysicalOperator)subScan, value);
        }

        @Override
        public Void visitStore(Store store, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            store.applyAssignments(value);
            return (Void)super.visitStore(store, value);
        }

        @Override
        public Void visitOp(PhysicalOperator op, List<CoordinationProtos.DrillbitEndpoint> value) throws PhysicalOperatorSetupException {
            return (Void)this.visitChildren(op, value);
        }
    }
}

