/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.fragment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.exception.FragmentSetupException;
import org.apache.drill.exec.expr.fn.impl.DateUtility;
import org.apache.drill.exec.ops.QueryContext;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.planner.PhysicalPlanReader;
import org.apache.drill.exec.planner.fragment.Fragment;
import org.apache.drill.exec.planner.fragment.Materializer;
import org.apache.drill.exec.planner.fragment.PlanningSet;
import org.apache.drill.exec.planner.fragment.Stats;
import org.apache.drill.exec.planner.fragment.Wrapper;
import org.apache.drill.exec.proto.BitControl;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.work.QueryWorkUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleParallelizer {
    static final Logger logger = LoggerFactory.getLogger(SimpleParallelizer.class);
    private final Materializer materializer = new Materializer();
    private final long parallelizationThreshold;
    private final int maxWidthPerNode;
    private final int maxGlobalWidth;
    private double affinityFactor;

    public SimpleParallelizer(QueryContext context) {
        long sliceTarget = context.getOptions().getOption((String)"planner.slice_target").num_val;
        this.parallelizationThreshold = sliceTarget > 0L ? sliceTarget : 1L;
        this.maxWidthPerNode = context.getOptions().getOption((String)"planner.width.max_per_node").num_val.intValue();
        this.maxGlobalWidth = context.getOptions().getOption((String)"planner.width.max_per_query").num_val.intValue();
        this.affinityFactor = context.getOptions().getOption((String)"planner.affinity_factor").float_val.intValue();
    }

    public QueryWorkUnit getFragments(OptionList options, CoordinationProtos.DrillbitEndpoint foremanNode, UserBitShared.QueryId queryId, Collection<CoordinationProtos.DrillbitEndpoint> activeEndpoints, PhysicalPlanReader reader, Fragment rootNode, PlanningSet planningSet) throws ExecutionSetupException {
        this.assignEndpoints(activeEndpoints, planningSet);
        return this.generateWorkUnit(options, foremanNode, queryId, reader, rootNode, planningSet);
    }

    private QueryWorkUnit generateWorkUnit(OptionList options, CoordinationProtos.DrillbitEndpoint foremanNode, UserBitShared.QueryId queryId, PhysicalPlanReader reader, Fragment rootNode, PlanningSet planningSet) throws ExecutionSetupException {
        ArrayList<BitControl.PlanFragment> fragments = Lists.newArrayList();
        BitControl.PlanFragment rootFragment = null;
        FragmentRoot rootOperator = null;
        long queryStartTime = System.currentTimeMillis();
        int timeZone = DateUtility.getIndex(System.getProperty("user.timezone"));
        for (Wrapper wrapper : planningSet) {
            boolean isRootNode;
            Fragment node = wrapper.getNode();
            Stats stats = node.getStats();
            PhysicalOperator physicalOperatorRoot = node.getRoot();
            boolean bl = isRootNode = rootNode == node;
            if (isRootNode && wrapper.getWidth() != 1) {
                throw new FragmentSetupException(String.format("Failure while trying to setup fragment.  The root fragment must always have parallelization one.  In the current case, the width was set to %d.", wrapper.getWidth()));
            }
            boolean isLeafFragment = node.getReceivingExchangePairs().size() == 0;
            for (int minorFragmentId = 0; minorFragmentId < wrapper.getWidth(); ++minorFragmentId) {
                String optionsData;
                String plan;
                Materializer.IndexedFragmentNode iNode = new Materializer.IndexedFragmentNode(minorFragmentId, wrapper);
                wrapper.resetAllocation();
                PhysicalOperator op = physicalOperatorRoot.accept(this.materializer, iNode);
                Preconditions.checkArgument(op instanceof FragmentRoot);
                FragmentRoot root = (FragmentRoot)op;
                try {
                    plan = reader.writeJson(root);
                    optionsData = reader.writeJson(options);
                }
                catch (JsonProcessingException e) {
                    throw new FragmentSetupException("Failure while trying to convert fragment into json.", e);
                }
                ExecProtos.FragmentHandle handle = ExecProtos.FragmentHandle.newBuilder().setMajorFragmentId(wrapper.getMajorFragmentId()).setMinorFragmentId(minorFragmentId).setQueryId(queryId).build();
                BitControl.PlanFragment fragment = BitControl.PlanFragment.newBuilder().setForeman(foremanNode).setFragmentJson(plan).setHandle(handle).setAssignment(wrapper.getAssignedEndpoint(minorFragmentId)).setLeafFragment(isLeafFragment).setQueryStartTime(queryStartTime).setTimeZone(timeZone).setMemInitial(wrapper.getInitialAllocation()).setMemMax(wrapper.getMaxAllocation()).setOptionsJson(optionsData).build();
                if (isRootNode) {
                    logger.debug("Root fragment:\n {}", (Object)DrillStringUtils.unescapeJava(fragment.toString()));
                    rootFragment = fragment;
                    rootOperator = root;
                    continue;
                }
                logger.debug("Remote fragment:\n {}", (Object)DrillStringUtils.unescapeJava(fragment.toString()));
                fragments.add(fragment);
            }
        }
        return new QueryWorkUnit(rootOperator, rootFragment, fragments);
    }

    private void assignEndpoints(Collection<CoordinationProtos.DrillbitEndpoint> allNodes, PlanningSet planningSet) throws PhysicalOperatorSetupException {
        for (Wrapper wrapper : planningSet) {
            Stats stats = wrapper.getStats();
            double targetSlices = stats.getTotalCost() / (double)this.parallelizationThreshold;
            int targetIntSlices = (int)Math.ceil(targetSlices);
            int width = Math.min(targetIntSlices, Math.min(stats.getMaxWidth(), this.maxGlobalWidth));
            if ((width = Math.min(width, this.maxWidthPerNode * allNodes.size())) < 1) {
                width = 1;
            }
            wrapper.setWidth(width);
            wrapper.assignEndpoints(allNodes, this.affinityFactor);
        }
    }
}

