/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.cost;

import org.apache.drill.exec.planner.cost.DrillRelOptCost;
import org.apache.drill.exec.planner.cost.DrillRelOptCostFactory;
import org.eigenbase.relopt.RelOptCost;
import org.eigenbase.util.Util;

public class DrillCostBase
implements DrillRelOptCost {
    static final DrillCostBase INFINITY = new DrillCostBase(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public String toString() {
            return "{inf}";
        }
    };
    static final DrillCostBase HUGE = new DrillCostBase(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE){

        @Override
        public String toString() {
            return "{huge}";
        }
    };
    static final DrillCostBase ZERO = new DrillCostBase(0.0, 0.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{0}";
        }
    };
    static final DrillCostBase TINY = new DrillCostBase(1.0, 1.0, 0.0, 0.0){

        @Override
        public String toString() {
            return "{tiny}";
        }
    };
    final double rowCount;
    final double cpu;
    final double io;
    final double network;
    final double memory;

    public DrillCostBase(double rowCount, double cpu, double io, double network) {
        this(rowCount, cpu, io, network, 0.0);
    }

    public DrillCostBase(double rowCount, double cpu, double io, double network, double memory) {
        this.rowCount = rowCount;
        this.cpu = cpu;
        this.io = io;
        this.network = network;
        this.memory = memory;
    }

    @Override
    public double getRows() {
        return this.rowCount;
    }

    @Override
    public double getCpu() {
        return this.cpu;
    }

    @Override
    public double getIo() {
        return this.io;
    }

    public double getMemory() {
        return this.memory;
    }

    public int hashCode() {
        return Util.hashCode(this.rowCount) + Util.hashCode(this.cpu) + Util.hashCode(this.io) + Util.hashCode(this.network);
    }

    @Override
    public boolean isInfinite() {
        return this == INFINITY || this.cpu == Double.POSITIVE_INFINITY || this.io == Double.POSITIVE_INFINITY || this.network == Double.POSITIVE_INFINITY || this.rowCount == Double.POSITIVE_INFINITY;
    }

    @Override
    public boolean isLe(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        return this == that || this.cpu + this.io + this.network <= that.cpu + that.io + that.network && this.rowCount <= that.rowCount;
    }

    @Override
    public boolean isLt(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        return this.cpu + this.io + this.network < that.cpu + that.io + that.network && this.rowCount <= that.rowCount;
    }

    @Override
    public RelOptCost plus(RelOptCost other) {
        DrillCostBase that = (DrillCostBase)other;
        if (this == INFINITY || that == INFINITY) {
            return INFINITY;
        }
        return new DrillCostBase(this.rowCount + that.rowCount, this.cpu + that.cpu, this.io + that.io, this.network + that.network, this.memory + that.memory);
    }

    @Override
    public RelOptCost multiplyBy(double factor) {
        if (this == INFINITY) {
            return this;
        }
        return new DrillCostBase(this.rowCount * factor, this.cpu * factor, this.io * factor, this.network * factor);
    }

    public String toString() {
        return "{" + this.rowCount + " rows, " + this.cpu + " cpu, " + this.io + " io, " + this.network + " network, " + this.memory + " memory}";
    }

    public static class DrillCostFactory
    implements DrillRelOptCostFactory {
        @Override
        public RelOptCost makeHugeCost() {
            return HUGE;
        }

        @Override
        public RelOptCost makeInfiniteCost() {
            return INFINITY;
        }

        @Override
        public RelOptCost makeTinyCost() {
            return TINY;
        }

        @Override
        public RelOptCost makeZeroCost() {
            return ZERO;
        }
    }
}

