/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import java.util.List;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.common.DrillRelOptUtil;
import org.eigenbase.rel.InvalidRelException;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.UnionRelBase;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;

public abstract class DrillUnionRelBase
extends UnionRelBase
implements DrillRelNode {
    public DrillUnionRelBase(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) throws InvalidRelException {
        super(cluster, traits, inputs, all);
        if (!this.isCompatible(false, true)) {
            throw new InvalidRelException("Input row types of the Union are not compatible.");
        }
    }

    public boolean isCompatible(boolean compareNames, boolean allowSubstring) {
        RelDataType unionType = this.getRowType();
        for (RelNode input : this.getInputs()) {
            if (DrillRelOptUtil.areRowTypesEqual(input.getRowType(), unionType, compareNames, allowSubstring)) continue;
            return false;
        }
        return true;
    }
}

