/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.exec.planner.StarColumnHelper;
import org.apache.drill.exec.planner.common.DrillRelNode;
import org.apache.drill.exec.planner.logical.DrillOptiq;
import org.apache.drill.exec.planner.logical.DrillParseContext;
import org.eigenbase.rel.ProjectRelBase;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.Convention;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelTraitSet;
import org.eigenbase.reltype.RelDataType;
import org.eigenbase.rex.RexNode;
import org.eigenbase.util.Pair;

public abstract class DrillProjectRelBase
extends ProjectRelBase
implements DrillRelNode {
    protected DrillProjectRelBase(Convention convention, RelOptCluster cluster, RelTraitSet traits, RelNode child, List<RexNode> exps, RelDataType rowType) {
        super(cluster, traits, child, exps, rowType, 1);
        assert (this.getConvention() == convention);
    }

    private List<Pair<RexNode, String>> projects() {
        return Pair.zip(this.exps, this.getRowType().getFieldNames());
    }

    protected List<NamedExpression> getProjectExpressions(DrillParseContext context) {
        ArrayList<NamedExpression> expressions = Lists.newArrayList();
        HashSet<String> starColPrefixes = new HashSet<String>();
        for (String string : this.getRowType().getFieldNames()) {
            if (!StarColumnHelper.isPrefixedStarColumn(string)) continue;
            starColPrefixes.add(StarColumnHelper.extractStarColumnPrefix(string));
        }
        for (Pair pair : this.projects()) {
            if (StarColumnHelper.subsumeRegColumn(starColPrefixes, (String)pair.right)) continue;
            LogicalExpression expr = DrillOptiq.toDrill(context, this.getChild(), (RexNode)pair.left);
            expressions.add(new NamedExpression(expr, FieldReference.getWithQuotedRef((CharSequence)pair.right)));
        }
        return expressions;
    }
}

