/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import java.util.List;
import java.util.Set;
import org.eigenbase.reltype.RelDataType;

public class StarColumnHelper {
    public static boolean containsStarColumn(RelDataType type) {
        List<String> fieldNames = type.getFieldNames();
        for (String s : fieldNames) {
            if (!s.startsWith("*")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrefixedStarColumn(String fieldName) {
        return fieldName.indexOf("\u00a6\u00a6*") > 0;
    }

    public static boolean isNonPrefixedStarColumn(String fieldName) {
        return fieldName.startsWith("*");
    }

    public static boolean isStarColumn(String fieldName) {
        return StarColumnHelper.isPrefixedStarColumn(fieldName) || StarColumnHelper.isNonPrefixedStarColumn(fieldName);
    }

    public static String extractStarColumnPrefix(String fieldName) {
        assert (StarColumnHelper.isPrefixedStarColumn(fieldName));
        return fieldName.substring(0, fieldName.indexOf("\u00a6\u00a6*"));
    }

    public static String extractColumnPrefix(String fieldName) {
        if (fieldName.indexOf("\u00a6\u00a6") >= 0) {
            return fieldName.substring(0, fieldName.indexOf("\u00a6\u00a6"));
        }
        return "";
    }

    public static boolean subsumeRegColumn(Set<String> prefixes, String fieldName) {
        if (StarColumnHelper.isPrefixedStarColumn(fieldName)) {
            return false;
        }
        return prefixes.contains(StarColumnHelper.extractColumnPrefix(fieldName));
    }
}

