/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.logical.LogicalPlan;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.coord.DrillbitEndpointSerDe;
import org.apache.drill.exec.physical.PhysicalPlan;
import org.apache.drill.exec.physical.base.FragmentLeaf;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalOperatorUtil;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.record.MajorTypeSerDe;
import org.apache.drill.exec.server.options.OptionList;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhysicalPlanReader {
    static final Logger logger = LoggerFactory.getLogger(PhysicalPlanReader.class);
    private final ObjectReader physicalPlanReader;
    private final ObjectMapper mapper;
    private final ObjectReader operatorReader;
    private final ObjectReader logicalPlanReader;

    public PhysicalPlanReader(DrillConfig config, ObjectMapper mapper, CoordinationProtos.DrillbitEndpoint endpoint, StoragePluginRegistry pluginRegistry) {
        SimpleModule deserModule = new SimpleModule("PhysicalOperatorModule").addSerializer(CoordinationProtos.DrillbitEndpoint.class, new DrillbitEndpointSerDe.Se()).addDeserializer(CoordinationProtos.DrillbitEndpoint.class, new DrillbitEndpointSerDe.De()).addSerializer(TypeProtos.MajorType.class, new MajorTypeSerDe.Se()).addDeserializer(TypeProtos.MajorType.class, new MajorTypeSerDe.De());
        mapper.registerModule(deserModule);
        mapper.registerSubtypes(PhysicalOperatorUtil.getSubTypes(config));
        InjectableValues.Std injectables = new InjectableValues.Std().addValue(StoragePluginRegistry.class, pluginRegistry).addValue(CoordinationProtos.DrillbitEndpoint.class, endpoint);
        this.mapper = mapper;
        this.physicalPlanReader = mapper.reader(PhysicalPlan.class).with(injectables);
        this.operatorReader = mapper.reader(PhysicalOperator.class).with(injectables);
        this.logicalPlanReader = mapper.reader(LogicalPlan.class).with(injectables);
    }

    public String writeJson(OptionList list) throws JsonProcessingException {
        return this.mapper.writeValueAsString(list);
    }

    public String writeJson(PhysicalOperator op) throws JsonProcessingException {
        return this.mapper.writeValueAsString(op);
    }

    public PhysicalPlan readPhysicalPlan(String json) throws JsonProcessingException, IOException {
        logger.debug("Reading physical plan {}", (Object)json);
        return (PhysicalPlan)this.physicalPlanReader.readValue(json);
    }

    public FragmentRoot readFragmentOperator(String json) throws JsonProcessingException, IOException {
        logger.debug("Attempting to read {}", (Object)json);
        PhysicalOperator op = (PhysicalOperator)this.operatorReader.readValue(json);
        if (op instanceof FragmentLeaf) {
            return (FragmentRoot)op;
        }
        throw new UnsupportedOperationException(String.format("The provided json fragment doesn't have a FragmentRoot as its root operator.  The operator was %s.", op.getClass().getCanonicalName()));
    }

    public LogicalPlan readLogicalPlan(String json) throws JsonProcessingException, IOException {
        logger.debug("Reading logical plan {}", (Object)json);
        return (LogicalPlan)this.logicalPlanReader.readValue(json);
    }
}

