/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.partitionsender;

import io.netty.buffer.ByteBuf;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.SendingAccountor;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.work.ErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusHandler
extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
    static final Logger logger = LoggerFactory.getLogger(StatusHandler.class);
    RpcException ex;
    SendingAccountor sendCount;
    FragmentContext context;
    boolean ok = true;

    public StatusHandler(SendingAccountor sendCount, FragmentContext context) {
        this.sendCount = sendCount;
        this.context = context;
    }

    @Override
    public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
        this.sendCount.decrement();
        super.success(value, buffer);
    }

    @Override
    public void failed(RpcException ex) {
        this.sendCount.decrement();
        logger.error("Failure while sending data to user.", ex);
        boolean verbose = this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
        ErrorHelper.logAndConvertError(this.context.getIdentity(), "Failure while sending fragment to client.", ex, logger, verbose);
        this.ok = false;
        this.ex = ex;
    }

    public boolean isOk() {
        return this.ok;
    }

    public RpcException getException() {
        return this.ex;
    }
}

