/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.partitionsender;

import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JType;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.HashPartitionSender;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.SendingAccountor;
import org.apache.drill.exec.physical.impl.partitionsender.Partitioner;
import org.apache.drill.exec.physical.impl.partitionsender.StatusHandler;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.FragmentWritableBatch;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.VectorWrapper;
import org.apache.drill.exec.rpc.data.DataTunnel;
import org.apache.drill.exec.vector.CopyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionSenderRootExec
extends BaseRootExec {
    static final Logger logger = LoggerFactory.getLogger(PartitionSenderRootExec.class);
    private RecordBatch incoming;
    private HashPartitionSender operator;
    private Partitioner partitioner;
    private FragmentContext context;
    private boolean ok;
    private final SendingAccountor sendCount;
    private final int outGoingBatchCount;
    private final HashPartitionSender popConfig;
    private final StatusHandler statusHandler;
    private final AtomicIntegerArray remainingReceivers;
    private final AtomicInteger remaingReceiverCount;
    private volatile boolean done;

    @Override
    public boolean innerNext() {
        RecordBatch.IterOutcome out;
        boolean newSchema = false;
        if (!this.ok) {
            this.stop();
            return false;
        }
        if (!this.done) {
            out = this.next(this.incoming);
        } else {
            this.incoming.kill(true);
            out = RecordBatch.IterOutcome.NONE;
        }
        logger.debug("Partitioner.next(): got next record batch with status {}", (Object)out);
        switch (out) {
            case NONE: {
                try {
                    if (this.partitioner != null) {
                        this.partitioner.flushOutgoingBatches(true, false);
                    } else {
                        this.sendEmptyBatch();
                    }
                }
                catch (IOException e) {
                    this.incoming.kill(false);
                    logger.error("Error while creating partitioning sender or flushing outgoing batches", e);
                    this.context.fail(e);
                }
                return false;
            }
            case STOP: {
                if (this.partitioner != null) {
                    this.partitioner.clear();
                }
                return false;
            }
            case OK_NEW_SCHEMA: {
                try {
                    if (this.partitioner != null) {
                        this.partitioner.flushOutgoingBatches(false, true);
                        this.partitioner.clear();
                    }
                    this.createPartitioner();
                }
                catch (IOException e) {
                    this.incoming.kill(false);
                    logger.error("Error while flushing outgoing batches", e);
                    this.context.fail(e);
                    return false;
                }
                catch (SchemaChangeException e) {
                    this.incoming.kill(false);
                    logger.error("Error while setting up partitioner", e);
                    this.context.fail(e);
                    return false;
                }
            }
            case OK: {
                try {
                    this.partitioner.partitionBatch(this.incoming);
                }
                catch (IOException e) {
                    this.context.fail(e);
                    this.incoming.kill(false);
                    return false;
                }
                for (VectorWrapper v : this.incoming) {
                    v.clear();
                }
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private void createPartitioner() throws SchemaChangeException {
        LogicalExpression expr = this.operator.getExpr();
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        ClassGenerator<Partitioner> cg = CodeGenerator.getRoot(Partitioner.TEMPLATE_DEFINITION, this.context.getFunctionRegistry());
        ClassGenerator<Partitioner> cgInner = cg.getInnerGenerator("OutgoingRecordBatch");
        LogicalExpression materializedExpr = ExpressionTreeMaterializer.materialize(expr, this.incoming, collector, this.context.getFunctionRegistry());
        if (collector.hasErrors()) {
            throw new SchemaChangeException(String.format("Failure while trying to materialize incoming schema.  Errors:\n %s.", collector.toErrorString()));
        }
        JExpression bucket = JExpr.direct((String)"bucket");
        ClassGenerator.HoldingContainer exprHolder = cg.addExpr(materializedExpr);
        cg.getEvalBlock().decl((JType)JType.parse((JCodeModel)cg.getModel(), (String)"int"), "bucket", exprHolder.getValue().mod(JExpr.lit((int)this.outGoingBatchCount)));
        cg.getEvalBlock()._return((JExpression)cg.getModel().ref(Math.class).staticInvoke("abs").arg(bucket));
        CopyUtil.generateCopies(cgInner, this.incoming, this.incoming.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.FOUR_BYTE);
        try {
            this.partitioner = this.context.getImplementationClass(cg);
            this.partitioner.setup(this.context, this.incoming, this.popConfig, this.stats, this.sendCount, this.oContext, this.statusHandler);
        }
        catch (IOException | ClassTransformationException e) {
            throw new SchemaChangeException("Failure while attempting to load generated class", e);
        }
    }

    @Override
    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        int id = handle.getMinorFragmentId();
        if (this.remainingReceivers.compareAndSet(id, 0, 1)) {
            this.partitioner.getOutgoingBatches().get(handle.getMinorFragmentId()).terminate();
            int remaining = this.remaingReceiverCount.decrementAndGet();
            if (remaining == 0) {
                this.done = true;
            }
        }
    }

    @Override
    public void stop() {
        logger.debug("Partition sender stopping.");
        this.ok = false;
        if (this.partitioner != null) {
            this.partitioner.clear();
        }
        this.sendCount.waitForSendComplete();
        if (!this.statusHandler.isOk()) {
            this.context.fail(this.statusHandler.getException());
        }
        this.oContext.close();
        this.incoming.cleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEmptyBatch() {
        ExecProtos.FragmentHandle handle = this.context.getHandle();
        int fieldId = 0;
        StatusHandler statusHandler = new StatusHandler(this.sendCount, this.context);
        for (CoordinationProtos.DrillbitEndpoint endpoint : this.popConfig.getDestinations()) {
            ExecProtos.FragmentHandle opposite = this.context.getHandle().toBuilder().setMajorFragmentId(this.popConfig.getOppositeMajorFragmentId()).setMinorFragmentId(fieldId).build();
            DataTunnel tunnel = this.context.getDataTunnel(endpoint, opposite);
            FragmentWritableBatch writableBatch = FragmentWritableBatch.getEmptyLastWithSchema(handle.getQueryId(), handle.getMajorFragmentId(), handle.getMinorFragmentId(), this.operator.getOppositeMajorFragmentId(), fieldId, this.incoming.getSchema());
            this.stats.startWait();
            try {
                tunnel.sendRecordBatch(statusHandler, writableBatch);
            }
            finally {
                this.stats.stopWait();
            }
            this.sendCount.increment();
            ++fieldId;
        }
    }

    public static enum Metric implements MetricDef
    {
        BATCHES_SENT,
        RECORDS_SENT,
        MIN_RECORDS,
        MAX_RECORDS,
        N_RECEIVERS,
        BYTES_SENT;


        @Override
        public int metricId() {
            return this.ordinal();
        }
    }
}

