/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.materialize;

import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.physical.impl.materialize.RecordMaterializer;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.WritableBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorRecordMaterializer
implements RecordMaterializer {
    static final Logger logger = LoggerFactory.getLogger(VectorRecordMaterializer.class);
    private UserBitShared.QueryId queryId;
    private RecordBatch batch;

    public VectorRecordMaterializer(FragmentContext context, RecordBatch batch) {
        this.queryId = context.getHandle().getQueryId();
        this.batch = batch;
        BatchSchema schema = batch.getSchema();
        assert (schema != null) : "Schema must be defined.";
    }

    @Override
    public QueryWritableBatch convertNext(boolean isLast) {
        WritableBatch w = this.batch.getWritableBatch();
        UserBitShared.QueryResult header = UserBitShared.QueryResult.newBuilder().setQueryId(this.queryId).setRowCount(this.batch.getRecordCount()).setDef(w.getDef()).setIsLastChunk(isLast).build();
        QueryWritableBatch batch = new QueryWritableBatch(header, w.getBuffers());
        return batch;
    }
}

