/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.materialize;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.MaterializedField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryWritableBatch {
    static final Logger logger = LoggerFactory.getLogger(QueryWritableBatch.class);
    private final UserBitShared.QueryResult header;
    private final ByteBuf[] buffers;

    public QueryWritableBatch(UserBitShared.QueryResult header, ByteBuf ... buffers) {
        this.header = header;
        this.buffers = buffers;
    }

    public ByteBuf[] getBuffers() {
        return this.buffers;
    }

    public long getByteCount() {
        long n = 0L;
        for (ByteBuf buf : this.buffers) {
            n += (long)buf.readableBytes();
        }
        return n;
    }

    public UserBitShared.QueryResult getHeader() {
        return this.header;
    }

    public String toString() {
        return "QueryWritableBatch [header=" + this.header + ", buffers=" + Arrays.toString(this.buffers) + "]";
    }

    public static QueryWritableBatch getEmptyBatchWithSchema(UserBitShared.QueryId queryId, int rowCount, boolean isLastChunk, BatchSchema schema) {
        ArrayList<UserBitShared.SerializedField> fields = Lists.newArrayList();
        for (MaterializedField field : schema) {
            fields.add(field.getAsBuilder().build());
        }
        UserBitShared.RecordBatchDef def = UserBitShared.RecordBatchDef.newBuilder().addAllField(fields).build();
        UserBitShared.QueryResult header = UserBitShared.QueryResult.newBuilder().setQueryId(queryId).setRowCount(rowCount).setDef(def).setIsLastChunk(isLastChunk).build();
        return new QueryWritableBatch(header, new ByteBuf[0]);
    }
}

