/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.join;

import io.netty.buffer.DrillBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.record.selection.SelectionVector4;

public class HashJoinHelper {
    List<SelectionVector4> startIndices = new ArrayList<SelectionVector4>();
    List<BuildInfo> buildInfoList = new ArrayList<BuildInfo>();
    FragmentContext context;
    BufferAllocator allocator;

    public HashJoinHelper(FragmentContext context, BufferAllocator allocator) {
        this.context = context;
        this.allocator = allocator;
    }

    public void addStartIndexBatch() throws SchemaChangeException {
        this.startIndices.add(this.getNewSV4(65536));
    }

    public SelectionVector4 getNewSV4(int recordCount) throws SchemaChangeException {
        DrillBuf vector = this.allocator.buffer(recordCount * 4);
        SelectionVector4 sv4 = new SelectionVector4(vector, recordCount, recordCount);
        for (int i = 0; i < recordCount; ++i) {
            sv4.set(i, -1);
        }
        return sv4;
    }

    public void addNewBatch(int recordCount) throws SchemaChangeException {
        BuildInfo info = new BuildInfo(this.getNewSV4(recordCount), new BitSet(recordCount), recordCount);
        this.buildInfoList.add(info);
    }

    public void setCurrentIndex(int keyIndex, int batchIndex, int recordIndex) throws SchemaChangeException {
        SelectionVector4 startIndex;
        int linkIndex;
        int batchIdx = keyIndex / 65536;
        int offsetIdx = keyIndex % 65536;
        if (keyIndex >= 65536 * this.startIndices.size()) {
            this.addStartIndexBatch();
        }
        if ((linkIndex = (startIndex = this.startIndices.get(batchIdx)).get(offsetIdx)) == -1) {
            startIndex.set(offsetIdx, batchIndex, recordIndex);
        } else {
            batchIdx = linkIndex >>> 16;
            offsetIdx = linkIndex & 0xFFFF;
            SelectionVector4 link = this.buildInfoList.get(batchIdx).getLinks();
            int firstLink = link.get(offsetIdx);
            if (firstLink == -1) {
                link.set(offsetIdx, batchIndex, recordIndex);
            } else {
                int firstLinkBatchIdx = firstLink >>> 16;
                int firstLinkOffsetIDx = firstLink & 0xFFFF;
                SelectionVector4 nextLink = this.buildInfoList.get(batchIndex).getLinks();
                nextLink.set(recordIndex, firstLinkBatchIdx, firstLinkOffsetIDx);
                link.set(offsetIdx, batchIndex, recordIndex);
            }
        }
    }

    public void clear() {
        for (SelectionVector4 sv4 : this.startIndices) {
            sv4.clear();
        }
        for (BuildInfo info : this.buildInfoList) {
            info.getLinks().clear();
        }
    }

    public class BuildInfo {
        private SelectionVector4 links;
        private BitSet keyMatchBitVector;
        private int recordCount;

        public BuildInfo(SelectionVector4 links, BitSet keyMatchBitVector, int recordCount) {
            this.links = links;
            this.keyMatchBitVector = keyMatchBitVector;
            this.recordCount = recordCount;
        }

        public SelectionVector4 getLinks() {
            return this.links;
        }
    }
}

