/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl.common;

import com.sun.codemodel.JConditional;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import java.io.IOException;
import org.apache.drill.common.expression.ErrorCollectorImpl;
import org.apache.drill.common.expression.FunctionHolderExpression;
import org.apache.drill.common.expression.LogicalExpression;
import org.apache.drill.common.logical.data.NamedExpression;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.compile.sig.GeneratorMapping;
import org.apache.drill.exec.compile.sig.MappingSet;
import org.apache.drill.exec.exception.ClassTransformationException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.expr.ClassGenerator;
import org.apache.drill.exec.expr.CodeGenerator;
import org.apache.drill.exec.expr.ExpressionTreeMaterializer;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.expr.ValueVectorReadExpression;
import org.apache.drill.exec.expr.ValueVectorWriteExpression;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.memory.BufferAllocator;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.impl.common.HashTable;
import org.apache.drill.exec.physical.impl.common.HashTableConfig;
import org.apache.drill.exec.record.MaterializedField;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.record.TypedFieldId;
import org.apache.drill.exec.record.VectorContainer;
import org.apache.drill.exec.vector.ValueVector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainedHashTable {
    static final Logger logger = LoggerFactory.getLogger(ChainedHashTable.class);
    private static final GeneratorMapping KEY_MATCH_BUILD = GeneratorMapping.create("setupInterior", "isKeyMatchInternalBuild", null, null);
    private static final GeneratorMapping KEY_MATCH_PROBE = GeneratorMapping.create("setupInterior", "isKeyMatchInternalProbe", null, null);
    private static final GeneratorMapping GET_HASH_BUILD = GeneratorMapping.create("doSetup", "getHashBuild", null, null);
    private static final GeneratorMapping GET_HASH_PROBE = GeneratorMapping.create("doSetup", "getHashProbe", null, null);
    private static final GeneratorMapping SET_VALUE = GeneratorMapping.create("setupInterior", "setValue", null, null);
    private static final GeneratorMapping OUTPUT_KEYS = GeneratorMapping.create("setupInterior", "outputRecordKeys", null, null);
    private static final GeneratorMapping SETUP_INTERIOR_CONSTANT = GeneratorMapping.create("setupInterior", "setupInterior", null, null);
    private static final GeneratorMapping DO_SETUP_CONSTANT = GeneratorMapping.create("doSetup", "doSetup", null, null);
    private final MappingSet KeyMatchIncomingBuildMapping = new MappingSet("incomingRowIdx", null, "incomingBuild", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_BUILD);
    private final MappingSet KeyMatchIncomingProbeMapping = new MappingSet("incomingRowIdx", null, "incomingProbe", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_PROBE);
    private final MappingSet KeyMatchHtableMapping = new MappingSet("htRowIdx", null, "htContainer", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_BUILD);
    private final MappingSet KeyMatchHtableProbeMapping = new MappingSet("htRowIdx", null, "htContainer", null, SETUP_INTERIOR_CONSTANT, KEY_MATCH_PROBE);
    private final MappingSet GetHashIncomingBuildMapping = new MappingSet("incomingRowIdx", null, "incomingBuild", null, DO_SETUP_CONSTANT, GET_HASH_BUILD);
    private final MappingSet GetHashIncomingProbeMapping = new MappingSet("incomingRowIdx", null, "incomingProbe", null, DO_SETUP_CONSTANT, GET_HASH_PROBE);
    private final MappingSet SetValueMapping = new MappingSet("incomingRowIdx", "htRowIdx", "incomingBuild", "htContainer", SETUP_INTERIOR_CONSTANT, SET_VALUE);
    private final MappingSet OutputRecordKeysMapping = new MappingSet("htRowIdx", "outRowIdx", "htContainer", "outgoing", SETUP_INTERIOR_CONSTANT, OUTPUT_KEYS);
    private HashTableConfig htConfig;
    private final FragmentContext context;
    private final BufferAllocator allocator;
    private final RecordBatch incomingBuild;
    private final RecordBatch incomingProbe;
    private final RecordBatch outgoing;

    public ChainedHashTable(HashTableConfig htConfig, FragmentContext context, BufferAllocator allocator, RecordBatch incomingBuild, RecordBatch incomingProbe, RecordBatch outgoing) {
        this.htConfig = htConfig;
        this.context = context;
        this.allocator = allocator;
        this.incomingBuild = incomingBuild;
        this.incomingProbe = incomingProbe;
        this.outgoing = outgoing;
    }

    public HashTable createAndSetupHashTable(TypedFieldId[] outKeyFieldIds) throws ClassTransformationException, IOException, SchemaChangeException {
        LogicalExpression expr;
        boolean isProbe;
        CodeGenerator<HashTable> top = CodeGenerator.get(HashTable.TEMPLATE_DEFINITION, this.context.getFunctionRegistry());
        ClassGenerator<HashTable> cg = top.getRoot();
        ClassGenerator<HashTable> cgInner = cg.getInnerGenerator("BatchHolder");
        LogicalExpression[] keyExprsBuild = new LogicalExpression[this.htConfig.getKeyExprsBuild().length];
        LogicalExpression[] keyExprsProbe = null;
        boolean bl = isProbe = this.htConfig.getKeyExprsProbe() != null;
        if (isProbe) {
            keyExprsProbe = new LogicalExpression[this.htConfig.getKeyExprsProbe().length];
        }
        ErrorCollectorImpl collector = new ErrorCollectorImpl();
        VectorContainer htContainerOrig = new VectorContainer();
        LogicalExpression[] htKeyExprs = new LogicalExpression[this.htConfig.getKeyExprsBuild().length];
        TypedFieldId[] htKeyFieldIds = new TypedFieldId[this.htConfig.getKeyExprsBuild().length];
        int i = 0;
        for (NamedExpression ne : this.htConfig.getKeyExprsBuild()) {
            expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incomingBuild, collector, this.context.getFunctionRegistry());
            if (collector.hasErrors()) {
                throw new SchemaChangeException("Failure while materializing expression. " + collector.toErrorString());
            }
            if (expr == null) continue;
            keyExprsBuild[i] = expr;
            MaterializedField outputField = MaterializedField.create(ne.getRef(), expr.getMajorType());
            ValueVector vv = TypeHelper.getNewVector(outputField, this.allocator);
            vv.allocateNew();
            htKeyFieldIds[i] = htContainerOrig.add(vv);
            ++i;
        }
        if (isProbe) {
            i = 0;
            for (NamedExpression ne : this.htConfig.getKeyExprsProbe()) {
                expr = ExpressionTreeMaterializer.materialize(ne.getExpr(), this.incomingProbe, collector, this.context.getFunctionRegistry());
                if (collector.hasErrors()) {
                    throw new SchemaChangeException("Failure while materializing expression. " + collector.toErrorString());
                }
                if (expr == null) continue;
                keyExprsProbe[i] = expr;
                ++i;
            }
        }
        this.setupIsKeyMatchInternal(cgInner, this.KeyMatchIncomingBuildMapping, this.KeyMatchHtableMapping, keyExprsBuild, htKeyFieldIds);
        this.setupIsKeyMatchInternal(cgInner, this.KeyMatchIncomingProbeMapping, this.KeyMatchHtableProbeMapping, keyExprsProbe, htKeyFieldIds);
        this.setupSetValue(cgInner, keyExprsBuild, htKeyFieldIds);
        if (this.outgoing != null && outKeyFieldIds.length > this.htConfig.getKeyExprsBuild().length) {
            throw new IllegalArgumentException("Mismatched number of output key fields.");
        }
        this.setupOutputRecordKeys(cgInner, htKeyFieldIds, outKeyFieldIds);
        this.setupGetHash(cg, this.GetHashIncomingBuildMapping, keyExprsBuild);
        this.setupGetHash(cg, this.GetHashIncomingProbeMapping, keyExprsProbe);
        HashTable ht = this.context.getImplementationClass(top);
        ht.setup(this.htConfig, this.context, this.allocator, this.incomingBuild, this.incomingProbe, this.outgoing, htContainerOrig);
        return ht;
    }

    private void setupIsKeyMatchInternal(ClassGenerator<HashTable> cg, MappingSet incomingMapping, MappingSet htableMapping, LogicalExpression[] keyExprs, TypedFieldId[] htKeyFieldIds) throws SchemaChangeException {
        cg.setMappingSet(incomingMapping);
        if (keyExprs == null || keyExprs.length == 0) {
            cg.getEvalBlock()._return(JExpr.FALSE);
            return;
        }
        int i = 0;
        for (LogicalExpression expr : keyExprs) {
            cg.setMappingSet(incomingMapping);
            ClassGenerator.HoldingContainer left = cg.addExpr(expr, false);
            cg.setMappingSet(htableMapping);
            ValueVectorReadExpression vvrExpr = new ValueVectorReadExpression(htKeyFieldIds[i++]);
            ClassGenerator.HoldingContainer right = cg.addExpr(vvrExpr, false);
            FunctionHolderExpression f = FunctionGenerationHelper.getComparator(left, right, this.context.getFunctionRegistry());
            ClassGenerator.HoldingContainer out = cg.addExpr(f, false);
            JConditional jc = cg.getEvalBlock()._if(out.getValue().ne(JExpr.lit((int)0)));
            jc._then()._return(JExpr.FALSE);
        }
        cg.getEvalBlock()._return(JExpr.TRUE);
    }

    private void setupSetValue(ClassGenerator<HashTable> cg, LogicalExpression[] keyExprs, TypedFieldId[] htKeyFieldIds) throws SchemaChangeException {
        cg.setMappingSet(this.SetValueMapping);
        int i = 0;
        for (LogicalExpression expr : keyExprs) {
            ValueVectorWriteExpression vvwExpr = new ValueVectorWriteExpression(htKeyFieldIds[i++], expr, true);
            ClassGenerator.HoldingContainer hc = cg.addExpr(vvwExpr, false);
            cg.getEvalBlock()._if(hc.getValue().eq(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
        }
        cg.getEvalBlock()._return(JExpr.TRUE);
    }

    private void setupOutputRecordKeys(ClassGenerator<HashTable> cg, TypedFieldId[] htKeyFieldIds, TypedFieldId[] outKeyFieldIds) {
        cg.setMappingSet(this.OutputRecordKeysMapping);
        if (outKeyFieldIds != null) {
            for (int i = 0; i < outKeyFieldIds.length; ++i) {
                ValueVectorReadExpression vvrExpr = new ValueVectorReadExpression(htKeyFieldIds[i]);
                ValueVectorWriteExpression vvwExpr = new ValueVectorWriteExpression(outKeyFieldIds[i], vvrExpr, true);
                ClassGenerator.HoldingContainer hc = cg.addExpr(vvwExpr);
                cg.getEvalBlock()._if(hc.getValue().eq(JExpr.lit((int)0)))._then()._return(JExpr.FALSE);
            }
            cg.getEvalBlock()._return(JExpr.TRUE);
        } else {
            cg.getEvalBlock()._return(JExpr.FALSE);
        }
    }

    private void setupGetHash(ClassGenerator<HashTable> cg, MappingSet incomingMapping, LogicalExpression[] keyExprs) throws SchemaChangeException {
        cg.setMappingSet(incomingMapping);
        if (keyExprs == null || keyExprs.length == 0) {
            cg.getEvalBlock()._return(JExpr.lit((int)0));
            return;
        }
        ClassGenerator.HoldingContainer combinedHashValue = null;
        for (int i = 0; i < keyExprs.length; ++i) {
            LogicalExpression expr = keyExprs[i];
            cg.setMappingSet(incomingMapping);
            ClassGenerator.HoldingContainer input = cg.addExpr(expr, false);
            FunctionHolderExpression hashfunc = FunctionGenerationHelper.getFunctionExpression("hash", Types.required(TypeProtos.MinorType.INT), this.context.getFunctionRegistry(), input);
            ClassGenerator.HoldingContainer hashValue = cg.addExpr(hashfunc, false);
            if (i == 0) {
                combinedHashValue = hashValue;
                continue;
            }
            FunctionHolderExpression xorfunc = FunctionGenerationHelper.getFunctionExpression("xor", Types.required(TypeProtos.MinorType.INT), this.context.getFunctionRegistry(), hashValue, combinedHashValue);
            combinedHashValue = cg.addExpr(xorfunc, false);
        }
        if (combinedHashValue != null) {
            cg.getEvalBlock()._return((JExpression)combinedHashValue.getValue());
        } else {
            cg.getEvalBlock()._return(JExpr.lit((int)0));
        }
    }
}

