/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.util.concurrent.Semaphore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingAccountor {
    static final Logger logger = LoggerFactory.getLogger(SendingAccountor.class);
    private int batchesSent = 0;
    private Semaphore wait = new Semaphore(0);

    public void increment() {
        ++this.batchesSent;
    }

    public void decrement() {
        this.wait.release();
    }

    public synchronized void waitForSendComplete() {
        try {
            this.wait.acquire(this.batchesSent);
            this.batchesSent = 0;
        }
        catch (InterruptedException e) {
            logger.warn("Failure while waiting for send complete.", e);
        }
    }
}

