/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.List;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.MetricDef;
import org.apache.drill.exec.physical.config.Screen;
import org.apache.drill.exec.physical.impl.BaseRootExec;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.SendingAccountor;
import org.apache.drill.exec.physical.impl.materialize.QueryWritableBatch;
import org.apache.drill.exec.physical.impl.materialize.RecordMaterializer;
import org.apache.drill.exec.physical.impl.materialize.VectorRecordMaterializer;
import org.apache.drill.exec.proto.GeneralRPCProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.rpc.BaseRpcOutcomeListener;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.exec.rpc.user.UserServer;
import org.apache.drill.exec.work.ErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenCreator
implements RootCreator<Screen> {
    static final Logger logger = LoggerFactory.getLogger(ScreenCreator.class);

    @Override
    public RootExec getRoot(FragmentContext context, Screen config, List<RecordBatch> children) throws ExecutionSetupException {
        Preconditions.checkNotNull(children);
        Preconditions.checkArgument(children.size() == 1);
        return new ScreenRoot(context, children.iterator().next(), config);
    }

    static class ScreenRoot
    extends BaseRootExec {
        static final Logger logger = LoggerFactory.getLogger(ScreenRoot.class);
        volatile boolean ok = true;
        private final SendingAccountor sendCount = new SendingAccountor();
        final RecordBatch incoming;
        final FragmentContext context;
        final UserServer.UserClientConnection connection;
        private RecordMaterializer materializer;
        private boolean first = true;
        private SendListener listener = new SendListener();

        public ScreenRoot(FragmentContext context, RecordBatch incoming, Screen config) throws OutOfMemoryException {
            super(context, config);
            assert (context.getConnection() != null) : "A screen root should only be run on the driving node which is connected directly to the client.  As such, this should always be true.";
            this.context = context;
            this.incoming = incoming;
            this.connection = context.getConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean innerNext() {
            if (!this.ok) {
                this.stop();
                this.context.fail(this.listener.ex);
                return false;
            }
            RecordBatch.IterOutcome outcome = this.next(this.incoming);
            switch (outcome) {
                case STOP: {
                    this.internalStop();
                    boolean verbose = this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
                    UserBitShared.QueryResult header = UserBitShared.QueryResult.newBuilder().setQueryId(this.context.getHandle().getQueryId()).setRowCount(0).setQueryState(UserBitShared.QueryResult.QueryState.FAILED).addError(ErrorHelper.logAndConvertError(this.context.getIdentity(), "Screen received stop request sent.", this.context.getFailureCause(), logger, verbose)).setDef(UserBitShared.RecordBatchDef.getDefaultInstance()).setIsLastChunk(true).build();
                    QueryWritableBatch batch = new QueryWritableBatch(header, new ByteBuf[0]);
                    this.stats.startWait();
                    try {
                        this.connection.sendResult(this.listener, batch);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.sendCount.increment();
                    return false;
                }
                case NONE: {
                    QueryWritableBatch batch;
                    this.internalStop();
                    if (!this.first) {
                        UserBitShared.QueryResult header = UserBitShared.QueryResult.newBuilder().setQueryId(this.context.getHandle().getQueryId()).setRowCount(0).setDef(UserBitShared.RecordBatchDef.getDefaultInstance()).setIsLastChunk(true).build();
                        batch = new QueryWritableBatch(header, new ByteBuf[0]);
                    } else {
                        batch = QueryWritableBatch.getEmptyBatchWithSchema(this.context.getHandle().getQueryId(), 0, true, this.incoming.getSchema());
                    }
                    this.stats.startWait();
                    try {
                        this.connection.sendResult(this.listener, batch);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.sendCount.increment();
                    return false;
                }
                case OK_NEW_SCHEMA: {
                    this.materializer = new VectorRecordMaterializer(this.context, this.incoming);
                }
                case OK: {
                    QueryWritableBatch batch = this.materializer.convertNext(false);
                    this.updateStats(batch);
                    this.stats.startWait();
                    try {
                        this.connection.sendResult(this.listener, batch);
                    }
                    finally {
                        this.stats.stopWait();
                    }
                    this.sendCount.increment();
                    this.first = false;
                    return true;
                }
            }
            throw new UnsupportedOperationException();
        }

        public void updateStats(QueryWritableBatch queryBatch) {
            this.stats.addLongStat(Metric.BYTES_SENT, queryBatch.getByteCount());
        }

        private void internalStop() {
            this.sendCount.waitForSendComplete();
            this.oContext.close();
            this.incoming.cleanup();
        }

        @Override
        public void stop() {
            if (!this.oContext.isClosed()) {
                this.internalStop();
            }
            this.sendCount.waitForSendComplete();
        }

        private class SendListener
        extends BaseRpcOutcomeListener<GeneralRPCProtos.Ack> {
            volatile RpcException ex;

            private SendListener() {
            }

            @Override
            public void success(GeneralRPCProtos.Ack value, ByteBuf buffer) {
                super.success(value, buffer);
                ScreenRoot.this.sendCount.decrement();
            }

            @Override
            public void failed(RpcException ex) {
                ScreenRoot.this.sendCount.decrement();
                logger.error("Failure while sending data to user.", ex);
                boolean verbose = ScreenRoot.this.context.getOptions().getOption((String)"exec.errors.verbose").bool_val;
                ErrorHelper.logAndConvertError(ScreenRoot.this.context.getIdentity(), "Failure while sending fragment to client.", ex, logger, verbose);
                ScreenRoot.this.ok = false;
                this.ex = ex;
            }
        }

        public static enum Metric implements MetricDef
        {
            BYTES_SENT;


            @Override
            public int metricId() {
                return this.ordinal();
            }
        }
    }
}

