/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.drill.common.config.DrillConfig;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.common.util.PathScanner;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperatorCreatorRegistry {
    static final Logger logger = LoggerFactory.getLogger(OperatorCreatorRegistry.class);
    private volatile Map<Class<?>, Constructor<?>> constructorRegistry = new HashMap();
    private volatile Map<Class<?>, Object> instanceRegistry = new HashMap();

    public OperatorCreatorRegistry(DrillConfig config) {
        this.addImplemntorsToMap(config, BatchCreator.class);
        this.addImplemntorsToMap(config, RootCreator.class);
        logger.debug("Adding Operator Creator map: {}", (Object)this.constructorRegistry);
    }

    public synchronized Object getOperatorCreator(Class<?> operator) throws ExecutionSetupException {
        Object opCreator = this.instanceRegistry.get(operator);
        if (opCreator != null) {
            return opCreator;
        }
        Constructor<?> c = this.constructorRegistry.get(operator);
        if (c == null) {
            throw new ExecutionSetupException(String.format("Failure finding OperatorCreator constructor for config %s", operator.getCanonicalName()));
        }
        try {
            opCreator = c.newInstance(new Object[0]);
            this.instanceRegistry.put(operator, opCreator);
            return opCreator;
        }
        catch (Throwable t) {
            throw ExecutionSetupException.fromThrowable(String.format("Failure creating OperatorCreator for Operator %s", operator.getCanonicalName()), t);
        }
    }

    private <T> void addImplemntorsToMap(DrillConfig config, Class<T> baseInterface) {
        Class<?>[] providerClasses;
        Class<?>[] arr$ = providerClasses = PathScanner.scanForImplementationsArr(baseInterface, config.getStringList("drill.physical.operator.packages"));
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Class<?> c;
            Class<?> operatorClass = c = arr$[i$];
            boolean interfaceFound = false;
            while (!interfaceFound && !c.equals(Object.class)) {
                Type[] ifaces;
                for (Type iface : ifaces = c.getGenericInterfaces()) {
                    if (!(iface instanceof ParameterizedType) || !((ParameterizedType)iface).getRawType().equals(baseInterface)) continue;
                    Type[] args = ((ParameterizedType)iface).getActualTypeArguments();
                    interfaceFound = true;
                    boolean constructorFound = false;
                    for (Constructor<?> constructor : operatorClass.getConstructors()) {
                        Class<?>[] params = constructor.getParameterTypes();
                        if (params.length != 0) continue;
                        Constructor<?> old = this.constructorRegistry.put((Class)args[0], constructor);
                        if (old != null) {
                            throw new RuntimeException(String.format("Duplicate OperatorCreator [%s, %s] found for PhysicalOperator %s", old.getDeclaringClass().getCanonicalName(), operatorClass.getCanonicalName(), ((Class)args[0]).getCanonicalName()));
                        }
                        constructorFound = true;
                    }
                    if (constructorFound) continue;
                    logger.debug("Skipping registration of OperatorCreator {} as it doesn't have a default constructor", (Object)operatorClass.getCanonicalName());
                }
                c = c.getSuperclass();
            }
        }
    }
}

