/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.exceptions.ExecutionSetupException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.physical.base.AbstractPhysicalVisitor;
import org.apache.drill.exec.physical.base.FragmentRoot;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.BatchCreator;
import org.apache.drill.exec.physical.impl.RootCreator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.physical.impl.validate.IteratorValidatorInjector;
import org.apache.drill.exec.record.RecordBatch;
import org.apache.drill.exec.util.AssertionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImplCreator
extends AbstractPhysicalVisitor<RecordBatch, FragmentContext, ExecutionSetupException> {
    static final Logger logger = LoggerFactory.getLogger(ImplCreator.class);
    private RootExec root = null;

    private ImplCreator() {
    }

    private RootExec getRoot() {
        return this.root;
    }

    @Override
    public RecordBatch visitOp(PhysicalOperator op, FragmentContext context) throws ExecutionSetupException {
        Preconditions.checkNotNull(op);
        Preconditions.checkNotNull(context);
        Object opCreator = context.getDrillbitContext().getOperatorCreatorRegistry().getOperatorCreator(op.getClass());
        if (opCreator != null) {
            if (op instanceof FragmentRoot) {
                this.root = ((RootCreator)opCreator).getRoot(context, op, this.getChildren(op, context));
                return null;
            }
            return ((BatchCreator)opCreator).getBatch(context, op, this.getChildren(op, context));
        }
        throw new UnsupportedOperationException(String.format("The PhysicalVisitor of type %s does not currently support visiting the PhysicalOperator type %s.", this.getClass().getCanonicalName(), op.getClass().getCanonicalName()));
    }

    private List<RecordBatch> getChildren(PhysicalOperator op, FragmentContext context) throws ExecutionSetupException {
        ArrayList<RecordBatch> children = Lists.newArrayList();
        for (PhysicalOperator child : op) {
            children.add(child.accept(this, context));
        }
        return children;
    }

    public static RootExec getExec(FragmentContext context, FragmentRoot root) throws ExecutionSetupException {
        ImplCreator i = new ImplCreator();
        if (AssertionUtil.isAssertionsEnabled()) {
            root = IteratorValidatorInjector.rewritePlanWithIteratorValidator(context, root);
        }
        Stopwatch watch = new Stopwatch();
        watch.start();
        root.accept(i, context);
        logger.debug("Took {} ms to accept", (Object)watch.elapsed(TimeUnit.MILLISECONDS));
        if (i.root == null) {
            throw new ExecutionSetupException("The provided fragment did not have a root node that correctly created a RootExec value.");
        }
        return i.getRoot();
    }
}

