/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.impl;

import org.apache.drill.exec.memory.OutOfMemoryException;
import org.apache.drill.exec.ops.FragmentContext;
import org.apache.drill.exec.ops.OpProfileDef;
import org.apache.drill.exec.ops.OperatorContext;
import org.apache.drill.exec.ops.OperatorStats;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.impl.RootExec;
import org.apache.drill.exec.proto.ExecProtos;
import org.apache.drill.exec.record.RecordBatch;

public abstract class BaseRootExec
implements RootExec {
    protected OperatorStats stats = null;
    protected OperatorContext oContext = null;

    public BaseRootExec(FragmentContext context, PhysicalOperator config) throws OutOfMemoryException {
        this.oContext = new OperatorContext(config, context, this.stats);
        this.stats = new OperatorStats(new OpProfileDef(config.getOperatorId(), config.getOperatorType(), OperatorContext.getChildCount(config)), this.oContext.getAllocator());
        context.getStats().addOperatorStats(this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean next() {
        assert (this.stats != null);
        try {
            this.stats.startProcessing();
            boolean bl = this.innerNext();
            return bl;
        }
        finally {
            this.stats.stopProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RecordBatch.IterOutcome next(RecordBatch b) {
        RecordBatch.IterOutcome next;
        this.stats.stopProcessing();
        try {
            next = b.next();
        }
        finally {
            this.stats.startProcessing();
        }
        switch (next) {
            case OK_NEW_SCHEMA: {
                this.stats.batchReceived(0, b.getRecordCount(), true);
                break;
            }
            case OK: {
                this.stats.batchReceived(0, b.getRecordCount(), false);
            }
        }
        return next;
    }

    public abstract boolean innerNext();

    @Override
    public void receivingFragmentFinished(ExecProtos.FragmentHandle handle) {
        logger.warn("Currently not handling FinishedFragment message");
    }
}

