/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.exec.physical.base.AbstractReceiver;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="unordered-receiver")
public class UnorderedReceiver
extends AbstractReceiver {
    static final Logger logger = LoggerFactory.getLogger(UnorderedReceiver.class);
    private List<CoordinationProtos.DrillbitEndpoint> senders;

    @JsonCreator
    public UnorderedReceiver(@JsonProperty(value="sender-major-fragment") int oppositeMajorFragmentId, @JsonProperty(value="senders") List<CoordinationProtos.DrillbitEndpoint> senders) {
        super(oppositeMajorFragmentId);
        this.senders = senders;
    }

    @Override
    @JsonProperty(value="senders")
    public List<CoordinationProtos.DrillbitEndpoint> getProvidingEndpoints() {
        return this.senders;
    }

    @Override
    public boolean supportsOutOfOrderExchange() {
        return true;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitUnorderedReceiver(this, value);
    }

    @Override
    public int getOperatorType() {
        return 11;
    }

    @JsonIgnore
    public int getNumSenders() {
        return this.senders.size();
    }
}

