/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.physical.config.UnorderedReceiver;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="union-exchange")
public class UnionExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(UnionExchange.class);
    private List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    private CoordinationProtos.DrillbitEndpoint destinationLocation;

    public UnionExchange(@JsonProperty(value="child") PhysicalOperator child) {
        super(child);
    }

    @Override
    public void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        if (receiverLocations.size() != 1) {
            throw new PhysicalOperatorSetupException("A Union Exchange only supports a single receiver endpoint.");
        }
        this.destinationLocation = receiverLocations.iterator().next();
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new SingleSender(this.receiverMajorFragmentId, child, this.destinationLocation);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new UnorderedReceiver(this.senderMajorFragmentId, this.senderLocations);
    }

    @Override
    public int getMaxSendWidth() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new UnionExchange(child);
    }
}

