/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.apache.drill.exec.physical.config.Sort;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="top-n")
public class TopN
extends Sort {
    static final Logger logger = LoggerFactory.getLogger(TopN.class);
    private final int limit;

    @JsonCreator
    public TopN(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderings, @JsonProperty(value="reverse") boolean reverse, @JsonProperty(value="limit") int limit) {
        super(child, orderings, reverse);
        this.limit = limit;
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitSort(this, value);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new TopN(child, this.orderings, this.reverse, this.limit);
    }

    @Override
    public int getOperatorType() {
        return 16;
    }
}

