/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.List;
import org.apache.drill.common.exceptions.PhysicalOperatorSetupException;
import org.apache.drill.common.logical.data.Order;
import org.apache.drill.exec.physical.base.AbstractExchange;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.Receiver;
import org.apache.drill.exec.physical.base.Sender;
import org.apache.drill.exec.physical.config.MergingReceiverPOP;
import org.apache.drill.exec.physical.config.SingleSender;
import org.apache.drill.exec.proto.CoordinationProtos;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="single-merge-exchange")
public class SingleMergeExchange
extends AbstractExchange {
    static final Logger logger = LoggerFactory.getLogger(SingleMergeExchange.class);
    private final List<Order.Ordering> orderExpr;
    private List<CoordinationProtos.DrillbitEndpoint> senderLocations;
    private CoordinationProtos.DrillbitEndpoint receiverLocation;

    @JsonCreator
    public SingleMergeExchange(@JsonProperty(value="child") PhysicalOperator child, @JsonProperty(value="orderings") List<Order.Ordering> orderExpr) {
        super(child);
        this.orderExpr = orderExpr;
    }

    @Override
    public int getMaxSendWidth() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void setupSenders(List<CoordinationProtos.DrillbitEndpoint> senderLocations) {
        this.senderLocations = senderLocations;
    }

    @Override
    protected void setupReceivers(List<CoordinationProtos.DrillbitEndpoint> receiverLocations) throws PhysicalOperatorSetupException {
        if (receiverLocations.size() != 1) {
            throw new PhysicalOperatorSetupException("SingleMergeExchange only supports a single receiver endpoint");
        }
        this.receiverLocation = receiverLocations.iterator().next();
    }

    @Override
    public Sender getSender(int minorFragmentId, PhysicalOperator child) {
        return new SingleSender(this.receiverMajorFragmentId, child, this.receiverLocation);
    }

    @Override
    public Receiver getReceiver(int minorFragmentId) {
        return new MergingReceiverPOP(this.senderMajorFragmentId, this.senderLocations, this.orderExpr);
    }

    @Override
    protected PhysicalOperator getNewWithChild(PhysicalOperator child) {
        return new SingleMergeExchange(child, this.orderExpr);
    }
}

