/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.physical.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.List;
import org.apache.drill.common.logical.data.JoinCondition;
import org.apache.drill.exec.physical.base.AbstractBase;
import org.apache.drill.exec.physical.base.PhysicalOperator;
import org.apache.drill.exec.physical.base.PhysicalVisitor;
import org.eigenbase.rel.JoinRelType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="merge-join")
public class MergeJoinPOP
extends AbstractBase {
    static final Logger logger = LoggerFactory.getLogger(MergeJoinPOP.class);
    private final PhysicalOperator left;
    private final PhysicalOperator right;
    private final List<JoinCondition> conditions;
    private final JoinRelType joinType;

    @JsonCreator
    public MergeJoinPOP(@JsonProperty(value="left") PhysicalOperator left, @JsonProperty(value="right") PhysicalOperator right, @JsonProperty(value="conditions") List<JoinCondition> conditions, @JsonProperty(value="joinType") JoinRelType joinType) {
        this.left = left;
        this.right = right;
        this.conditions = conditions;
        Preconditions.checkArgument(joinType != null, "Join type is missing!");
        this.joinType = joinType;
        Preconditions.checkArgument(joinType != JoinRelType.FULL, "Full outer join not currently supported");
    }

    @Override
    public <T, X, E extends Throwable> T accept(PhysicalVisitor<T, X, E> physicalVisitor, X value) throws E {
        return physicalVisitor.visitMergeJoin(this, value);
    }

    @Override
    public PhysicalOperator getNewWithChildren(List<PhysicalOperator> children) {
        Preconditions.checkArgument(children.size() == 2);
        return new MergeJoinPOP(children.get(0), children.get(1), this.conditions, this.joinType);
    }

    @Override
    public Iterator<PhysicalOperator> iterator() {
        return Iterators.forArray(this.left, this.right);
    }

    @Override
    public int getOperatorType() {
        return 5;
    }
}

